/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.common.filemaker.FilenameMaker;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSource;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMatchers;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MappingsLoaderAcceptanceTest {
    private WireMockConfiguration configuration;
    private WireMockServer wireMockServer;
    private WireMockTestClient testClient;

    @BeforeEach
    public void init() {
        this.configuration = WireMockConfiguration.wireMockConfig().dynamicPort();
    }

    @AfterEach
    public void stopWireMock() {
        this.wireMockServer.stop();
    }

    private void buildWireMock(Options options) {
        this.wireMockServer = new WireMockServer(options);
        this.wireMockServer.start();
        this.testClient = new WireMockTestClient(this.wireMockServer.port());
    }

    @Test
    public void mappingsLoadedFromJsonFiles() {
        this.buildWireMock((Options)this.configuration);
        this.wireMockServer.loadMappingsUsing((MappingsLoader)new JsonFileMappingsSource((FileSource)new SingleRootFileSource(TestFiles.filePath("test-requests")), new FilenameMaker()));
        WireMockResponse response = this.testClient.get("/canned/resource/1", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
        response = this.testClient.get("/canned/resource/2", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)401));
    }

    @Test
    public void mappingsLoadedViaClasspath() {
        this.buildWireMock((Options)this.configuration.usingFilesUnderClasspath("classpath-filesource"));
        MatcherAssert.assertThat((Object)this.testClient.get("/test", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"THINGS!"));
    }

    @Test
    public void loadsStubMappingsFromAMixtureOfSingleAndMultiStubFiles() {
        this.buildWireMock((Options)this.configuration);
        this.wireMockServer.resetMappings();
        this.wireMockServer.loadMappingsUsing((MappingsLoader)new JsonFileMappingsSource((FileSource)new SingleRootFileSource(TestFiles.filePath("multi-stub")), new FilenameMaker()));
        List stubs = this.wireMockServer.listAllStubMappings().getMappings();
        MatcherAssert.assertThat((Object)stubs.size(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/single/1")));
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/multi/1")));
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/multi/2")));
        MatcherAssert.assertThat((Object)stubs, (Matcher)Matchers.hasItem(WireMatchers.stubMappingWithUrl("/multi/3")));
    }
}

