/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

public class LoggedResponseTruncationTest {
    static final int MAX_SIZE = 1400;
    @RegisterExtension
    static WireMockExtension wm = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().maxLoggedResponseSize(1400)).build();
    WireMockTestClient client;

    @BeforeEach
    void init() {
        wm.resetAll();
        this.client = new WireMockTestClient(wm.getPort());
    }

    @Test
    void includesFullResponseBodyWhenBelowConfiguredThreshold() {
        String bigBody = RandomStringUtils.randomAlphabetic((int)1399);
        wm.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok((String)bigBody)));
        this.client.get("/big", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)((ServeEvent)wm.getAllServeEvents().get(0)).getResponse().getBodyAsString(), (Matcher)Matchers.is((Object)bigBody));
    }

    @Test
    void includesFullResponseBodyWhenAtConfiguredThreshold() {
        String bigBody = RandomStringUtils.randomAlphabetic((int)1399);
        wm.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok((String)bigBody)));
        this.client.get("/big", new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)((ServeEvent)wm.getAllServeEvents().get(0)).getResponse().getBodyAsString(), (Matcher)Matchers.is((Object)bigBody));
    }

    @Test
    void truncatesResponseBodyWhenOverConfiguredThreshold() {
        String bigBody = RandomStringUtils.randomAlphabetic((int)1401);
        wm.stubFor(WireMock.any((UrlPattern)WireMock.anyUrl()).willReturn(WireMock.ok((String)bigBody)));
        this.client.get("/big", new TestHttpHeader[0]);
        String expectedLoggedBody = bigBody.substring(0, 1400);
        String loggedResponseBody = ((ServeEvent)wm.getAllServeEvents().get(0)).getResponse().getBodyAsString();
        MatcherAssert.assertThat((Object)loggedResponseBody, (Matcher)Matchers.is((Object)expectedLoggedBody));
        MatcherAssert.assertThat((Object)loggedResponseBody.length(), (Matcher)Matchers.is((Object)1400));
    }
}

