/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestFiles;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class JsonSchemaMatchingAcceptanceTest
extends AcceptanceTestBase {
    @Test
    void matchesStubWhenRequestBodyJsonValidatesAgainstSchema() {
        String schema = TestFiles.file("schema-validation/new-pet.schema.json");
        String json = TestFiles.file("schema-validation/new-pet.json");
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/schema-match")).withRequestBody((ContentPattern)WireMock.matchingJsonSchema((String)schema)).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.postJson("/schema-match", json, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    void doesNotMatchStubWhenRequestBodyJsonDoesNotValidateAgainstSchema() {
        String schema = TestFiles.file("schema-validation/new-pet.schema.json");
        String json = TestFiles.file("schema-validation/new-pet.invalid.json");
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/schema-match")).withRequestBody((ContentPattern)WireMock.matchingJsonSchema((String)schema)).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.postJson("/schema-match", json, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    void doesNotMatchStubWhenRequestBodyIsNotValidJson() {
        String schema = TestFiles.file("schema-validation/new-pet.schema.json");
        String json = TestFiles.file("schema-validation/new-pet.unparseable.json");
        WireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlPathEqualTo((String)"/schema-match")).withRequestBody((ContentPattern)WireMock.matchingJsonSchema((String)schema)).willReturn(WireMock.ok()));
        WireMockResponse response = testClient.postJson("/schema-match", json, new TestHttpHeader[0]);
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
    }
}

