/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.AcceptanceTestBase;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class HeaderMatchingAcceptanceTest
extends AcceptanceTestBase {
    @Test
    public void mappingWithExactUrlMethodAndHeaderMatchingIsCreatedAndReturned() {
        testClient.addResponse("{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"url\": \"/header/dependent\",\t\t\t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\n\t\t\t\"Accept\": {\t\t\t\t\t\t\t\n\t\t\t\t\"equalTo\": \"text/xml\"\t\t\t\n\t\t\t},\t\t\t\t\t\t\t\t\t\t\n\t\t\t\"If-None-Match\": {\t\t\t\t\t\n\t\t\t\t\"equalTo\": \"abcd1234\"\t\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 304,\t\t\t\t\t\t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\n\t\t\t\"Content-Type\": \"text/xml\"\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t");
        WireMockResponse response = testClient.get("/header/dependent", TestHttpHeader.withHeader("Accept", "text/xml"), TestHttpHeader.withHeader("If-None-Match", "abcd1234"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)304));
    }

    @Test
    public void mappingMatchedWithRegexHeaders() {
        testClient.addResponse("{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"url\": \"/header/match/dependent\",\t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\n\t\t\t\"Accept\": {\t\t\t\t\t\t\t\n\t\t\t\t\"matches\": \"(.*)xml(.*)\"\t\t\n\t\t\t},\t\t\t\t\t\t\t\t\t\t\n\t\t\t\"If-None-Match\": {\t\t\t\t\t\n\t\t\t\t\"matches\": \"([a-z0-9]*)\"\t\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 304,\t\t\t\t\t\t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\n\t\t\t\"Content-Type\": \"text/xml\"\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t");
        WireMockResponse response = testClient.get("/header/match/dependent", TestHttpHeader.withHeader("Accept", "text/xml"), TestHttpHeader.withHeader("If-None-Match", "abcd1234"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)304));
    }

    @Test
    public void mappingMatchedWithNegativeRegexHeader() {
        testClient.addResponse("{ \t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"request\": {\t\t\t\t\t\t\t\t\t\n\t\t\"method\": \"GET\",\t\t\t\t\t\t\n\t\t\"url\": \"/header/match/dependent\",\t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\n\t\t\t\"Accept\": {\t\t\t\t\t\t\t\n\t\t\t\t\"doesNotMatch\": \"(.*)xml(.*)\"\t\n\t\t\t}\t\t\t\t\t\t\t\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t},\t\t\t\t\t\t\t\t\t\t\t\t\n\t\"response\": {\t\t\t\t\t\t\t\t\t\n\t\t\"status\": 200,\t\t\t\t\t\t\t\n\t\t\"headers\": {\t\t\t\t\t\t\t\t\n\t\t\t\"Content-Type\": \"text/xml\"\t\t\t\n\t\t}\t\t\t\t\t\t\t\t\t\t\t\n\t}\t\t\t\t\t\t\t\t\t\t\t\t\n}\t\t\t\t\t\t\t\t\t\t\t\t\t");
        WireMockResponse response = testClient.get("/header/match/dependent", TestHttpHeader.withHeader("Accept", "text/xml"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)404));
        response = testClient.get("/header/match/dependent", TestHttpHeader.withHeader("Accept", "application/json"));
        MatcherAssert.assertThat((Object)response.statusCode(), (Matcher)Matchers.is((Object)200));
    }
}

