/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.testsupport.TestHttpHeader;
import com.github.tomakehurst.wiremock.testsupport.WireMockResponse;
import com.github.tomakehurst.wiremock.testsupport.WireMockTestClient;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class BrowserProxyAcceptanceTest {
    @RegisterExtension
    public static WireMockExtension target = WireMockExtension.newInstance().build();
    private WireMockServer proxy;
    private WireMockTestClient testClient;

    BrowserProxyAcceptanceTest() {
    }

    @BeforeEach
    public void init() {
        this.testClient = new WireMockTestClient(target.getPort());
        this.proxy = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().enableBrowserProxying(true));
        this.proxy.start();
    }

    @AfterEach
    public void stopServer() {
        if (this.proxy.isRunning()) {
            this.proxy.stop();
        }
    }

    @Test
    public void canProxyHttp() {
        target.stubFor(WireMock.get((String)"/whatever").willReturn(WireMock.aResponse().withBody("Got it")));
        MatcherAssert.assertThat((Object)this.testClient.getViaProxy(target.url("/whatever"), this.proxy.port()).content(), (Matcher)Matchers.is((Object)"Got it"));
    }

    @Test
    public void passesQueryParameters() {
        target.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/search?q=things&limit=10")).willReturn(WireMock.aResponse().withStatus(200)));
        MatcherAssert.assertThat((Object)this.testClient.getViaProxy(target.url("/search?q=things&limit=10"), this.proxy.port()).statusCode(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void returnNotConfiguredResponseOnPassThroughDisabled() {
        target.stubFor(WireMock.get((String)"/whatever").willReturn(WireMock.ok((String)"Got it")));
        GlobalSettings newSettings = target.getGlobalSettings().getSettings().copy().proxyPassThrough(false).build();
        target.updateGlobalSettings(newSettings);
        MatcherAssert.assertThat((Object)this.testClient.getViaProxy(target.url("/something"), this.proxy.port()).statusCode(), (Matcher)Matchers.is((Object)404));
    }

    @Test
    public void returnStubbedResponseOnPassThroughDisabled() {
        this.proxy.updateGlobalSettings(this.proxy.getGlobalSettings().getSettings().copy().proxyPassThrough(false).build());
        this.proxy.stubFor(WireMock.get((String)"/whatever").willReturn(WireMock.ok((String)"Default response")));
        WireMockResponse wireMockResponse = this.testClient.getViaProxy(target.url("/whatever"), this.proxy.port());
        MatcherAssert.assertThat((Object)wireMockResponse.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)wireMockResponse.content(), (Matcher)Matchers.is((Object)"Default response"));
    }

    @Test
    public void returnStubbedResponseOnPassThroughEnabled() {
        target.stubFor(WireMock.get((String)"/whatever").willReturn(WireMock.ok((String)"Got it")));
        WireMockResponse wireMockResponse = this.testClient.getViaProxy(target.url("/whatever"), this.proxy.port());
        MatcherAssert.assertThat((Object)wireMockResponse.statusCode(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)wireMockResponse.content(), (Matcher)Matchers.is((Object)"Got it"));
    }

    @Test
    void disablingPassThroughDoesNotAffectReverseProxying() {
        this.proxy.updateGlobalSettings(this.proxy.getGlobalSettings().getSettings().copy().proxyPassThrough(false).build());
        this.proxy.stubFor(WireMock.proxyAllTo((String)target.baseUrl()));
        target.stubFor(WireMock.get((String)"/whatever").willReturn(WireMock.ok((String)"Got it")));
        WireMockTestClient testClient = new WireMockTestClient(this.proxy.port());
        MatcherAssert.assertThat((Object)testClient.get("/whatever", new TestHttpHeader[0]).content(), (Matcher)Matchers.is((Object)"Got it"));
    }

    @Nested
    class Disabled {
        @RegisterExtension
        public WireMockExtension wmWithoutBrowserProxy = WireMockExtension.newInstance().build();

        Disabled() {
        }

        @Test
        public void browserProxyIsReportedAsFalseInRequestLogWhenDisabled() {
            int httpPort = this.wmWithoutBrowserProxy.getPort();
            WireMockTestClient testClient = new WireMockTestClient(httpPort);
            testClient.getViaProxy("http://whereever/whatever", httpPort);
            LoggedRequest request = (LoggedRequest)this.wmWithoutBrowserProxy.findRequestsMatching(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/whatever")).build()).getRequests().get(0);
            MatcherAssert.assertThat((Object)request.isBrowserProxyRequest(), (Matcher)Matchers.is((Object)false));
        }
    }
}

