/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.jetty11.Jetty11HttpServer;
import com.github.tomakehurst.wiremock.store.BlobStore;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.wiremock.grpc.internal.GrpcFilter;

public class GrpcHttpServerFactory
implements HttpServerFactory {
    private final BlobStore protoDescriptorStore;
    private GrpcFilter grpcFilter;

    public GrpcHttpServerFactory(BlobStore protoDescriptorStore) {
        this.protoDescriptorStore = protoDescriptorStore;
    }

    public void loadFileDescriptors() {
        ArrayList<Descriptors.FileDescriptor> fileDescriptors = new ArrayList<Descriptors.FileDescriptor>();
        this.protoDescriptorStore.getAllKeys().filter(key -> key.endsWith(".dsc") || key.endsWith(".desc")).map(key -> this.protoDescriptorStore.get(key).map(data -> (DescriptorProtos.FileDescriptorSet)Exceptions.uncheck(() -> DescriptorProtos.FileDescriptorSet.parseFrom((byte[])data), DescriptorProtos.FileDescriptorSet.class))).filter(Optional::isPresent).map(Optional::get).flatMap(fileDescriptorSet -> fileDescriptorSet.getFileList().stream()).forEach(fileDescriptorProto -> Exceptions.uncheck(() -> fileDescriptors.add(Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])((Descriptors.FileDescriptor[])fileDescriptors.toArray(Descriptors.FileDescriptor[]::new)), (boolean)true))));
        this.grpcFilter.loadFileDescriptors(fileDescriptors);
    }

    public String getName() {
        return "grpc";
    }

    public HttpServer buildHttpServer(Options options, AdminRequestHandler adminRequestHandler, final StubRequestHandler stubRequestHandler) {
        return new Jetty11HttpServer(options, adminRequestHandler, stubRequestHandler){

            protected void decorateMockServiceContextBeforeConfig(ServletContextHandler mockServiceContext) {
                GrpcHttpServerFactory.this.grpcFilter = new GrpcFilter(stubRequestHandler);
                GrpcHttpServerFactory.this.loadFileDescriptors();
                FilterHolder filterHolder = new FilterHolder((Filter)GrpcHttpServerFactory.this.grpcFilter);
                mockServiceContext.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
            }
        };
    }
}

