/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.dsl;

import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import org.wiremock.annotations.Beta;
import org.wiremock.grpc.dsl.GrpcStubMappingBuilder;
import org.wiremock.grpc.dsl.GrpcVerification;

@Beta(justification="Incubating extension: https://github.com/wiremock/wiremock/issues/2383")
public class WireMockGrpcService {
    private final WireMock wireMock;
    private final String serviceName;

    public WireMockGrpcService(WireMock wireMock, String serviceName) {
        this.wireMock = wireMock;
        this.serviceName = serviceName;
    }

    public StubMapping stubFor(GrpcStubMappingBuilder builder) {
        StubMapping stubMapping = builder.build(this.serviceName);
        this.wireMock.register(stubMapping);
        return stubMapping;
    }

    public GrpcVerification verify(String method) {
        return new GrpcVerification(this.wireMock, WireMock.moreThanOrExactly((int)1), this.serviceName, method);
    }

    public GrpcVerification verify(int count, String method) {
        return new GrpcVerification(this.wireMock, WireMock.exactly((int)count), this.serviceName, method);
    }

    public GrpcVerification verify(CountMatchingStrategy countMatch, String method) {
        return new GrpcVerification(this.wireMock, countMatch, this.serviceName, method);
    }

    public void removeAllStubs() {
        String servicePath = "/" + this.serviceName;
        this.wireMock.allStubMappings().getMappings().stream().filter(mapping -> {
            RequestPattern requestMatcher = mapping.getRequest();
            RequestMethod requestMethod = requestMatcher.getMethod();
            String requestPath = requestMatcher.getUrlPath();
            return requestMethod != null && requestPath != null && requestMethod.match(RequestMethod.POST).isExactMatch() && requestPath.startsWith(servicePath);
        }).forEach(arg_0 -> ((WireMock)this.wireMock).removeStubMapping(arg_0));
    }

    public void resetRequests() {
        this.wireMock.removeEvents(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathMatching((String)("/" + this.serviceName + "/.+"))));
    }

    public void resetAll() {
        this.removeAllStubs();
        this.resetRequests();
    }
}

