/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum SnapshotOutputFormatter {
    FULL{

        @Override
        public SnapshotRecordResult format(List<StubMapping> stubMappings) {
            return SnapshotRecordResult.full(stubMappings);
        }
    }
    ,
    IDS{

        @Override
        public SnapshotRecordResult format(List<StubMapping> stubMappings) {
            return SnapshotRecordResult.idsFromMappings(stubMappings);
        }
    };


    public abstract SnapshotRecordResult format(List<StubMapping> var1);

    @JsonCreator
    public static SnapshotOutputFormatter fromString(String value) {
        if (value == null || value.equalsIgnoreCase("full")) {
            return FULL;
        }
        if (value.equalsIgnoreCase("ids")) {
            return IDS;
        }
        throw new IllegalArgumentException("Invalid output format");
    }
}

