/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.matching.EqualToPatternWithCaseInsensitivePrefix;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;

public class BasicCredentials {
    public final String username;
    public final String password;

    @JsonCreator
    public BasicCredentials(@JsonProperty(value="username") String username, @JsonProperty(value="password") String password) {
        this.username = username;
        this.password = password;
    }

    public boolean present() {
        return this.username != null && this.password != null;
    }

    public MultiValuePattern asAuthorizationMultiValuePattern() {
        return MultiValuePattern.of(new EqualToPatternWithCaseInsensitivePrefix("Basic ", this.encodedUsernameAndPassword()));
    }

    public String asAuthorizationHeaderValue() {
        return "Basic " + this.encodedUsernameAndPassword();
    }

    private String encodedUsernameAndPassword() {
        byte[] usernameAndPassword = (this.username + ":" + this.password).getBytes();
        return Encoding.encodeBase64(usernameAndPassword);
    }
}

