/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.requestfilter;

import com.github.tomakehurst.wiremock.extension.requestfilter.ContinueAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilter;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterV2;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.List;

public class FilterProcessor {
    private final List<? extends RequestFilter> v1RequestFilters;
    private final List<? extends RequestFilterV2> v2RequestFilters;

    public FilterProcessor(List<? extends RequestFilter> v1RequestFilters, List<? extends RequestFilterV2> v2RequestFilters) {
        this.v1RequestFilters = v1RequestFilters;
        this.v2RequestFilters = v2RequestFilters;
    }

    public RequestFilterAction processFilters(Request request, ServeEvent serveEvent) {
        RequestFilterAction requestFilterAction = this.processV1Filters(request, this.v1RequestFilters, RequestFilterAction.continueWith(request));
        if (requestFilterAction instanceof ContinueAction) {
            return this.processV2Filters(request, serveEvent, this.v2RequestFilters, requestFilterAction);
        }
        return requestFilterAction;
    }

    private RequestFilterAction processV1Filters(Request request, List<? extends RequestFilter> requestFilters, RequestFilterAction lastAction) {
        if (requestFilters.isEmpty()) {
            return lastAction;
        }
        RequestFilterAction action = requestFilters.get(0).filter(request);
        if (action instanceof ContinueAction) {
            Request newRequest = ((ContinueAction)action).getRequest();
            return this.processV1Filters(newRequest, requestFilters.subList(1, requestFilters.size()), action);
        }
        return action;
    }

    private RequestFilterAction processV2Filters(Request request, ServeEvent serveEvent, List<? extends RequestFilterV2> v2RequestFilters, RequestFilterAction lastAction) {
        if (v2RequestFilters.isEmpty()) {
            return lastAction;
        }
        RequestFilterAction action = v2RequestFilters.get(0).filter(request, serveEvent);
        if (action instanceof ContinueAction) {
            Request newRequest = ((ContinueAction)action).getRequest();
            return this.processV2Filters(newRequest, serveEvent, v2RequestFilters.subList(1, v2RequestFilters.size()), action);
        }
        return action;
    }

    public boolean hasAnyFilters() {
        return !this.v1RequestFilters.isEmpty() || !this.v2RequestFilters.isEmpty();
    }
}

