/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Exceptions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class HttpClientUtils {
    private HttpClientUtils() {
    }

    public static String getEntityAsStringAndCloseStream(ClassicHttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try {
                String content = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                entity.getContent().close();
                return content;
            }
            catch (IOException | ParseException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getEntityAsByteArrayAndCloseStream(ClassicHttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        try {
            if (entity != null) {
                byte[] byArray = EntityUtils.toByteArray((HttpEntity)entity);
                return byArray;
            }
            Exceptions.uncheck(() -> httpResponse.close());
        }
        catch (IOException ioe) {
            byte[] byArray = Exceptions.throwUnchecked(ioe, byte[].class);
            return byArray;
        }
        finally {
            Exceptions.uncheck(() -> httpResponse.close());
        }
        return null;
    }

    public static byte[] getEntityAsByteArray(ClassicHttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        try {
            if (entity != null) {
                return EntityUtils.toByteArray((HttpEntity)entity);
            }
        }
        catch (IOException ioe) {
            return Exceptions.throwUnchecked(ioe, byte[].class);
        }
        return null;
    }
}

