/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.Comparator;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

public class SortedConcurrentMappingSet
implements Iterable<StubMapping> {
    private final AtomicLong insertionCount = new AtomicLong();
    private final ConcurrentSkipListSet<StubMapping> mappingSet = new ConcurrentSkipListSet<StubMapping>(this.sortedByPriorityThenReverseInsertionOrder());

    private Comparator<StubMapping> sortedByPriorityThenReverseInsertionOrder() {
        return (one, two) -> {
            int priorityComparison = one.comparePriorityWith((StubMapping)two);
            if (priorityComparison != 0) {
                return priorityComparison;
            }
            return Long.compare(two.getInsertionIndex(), one.getInsertionIndex());
        };
    }

    @Override
    public Iterator<StubMapping> iterator() {
        return this.mappingSet.iterator();
    }

    public Stream<StubMapping> stream() {
        return this.mappingSet.stream();
    }

    public void add(StubMapping mapping) {
        mapping.setInsertionIndex(this.insertionCount.getAndIncrement());
        this.mappingSet.add(mapping);
    }

    public boolean remove(UUID mappingId) {
        return this.mappingSet.removeIf(mapping -> mappingId != null && mappingId.equals(mapping.getUuid()));
    }

    public boolean replace(StubMapping existingStubMapping, StubMapping newStubMapping) {
        if (this.mappingSet.remove(existingStubMapping)) {
            this.mappingSet.add(newStubMapping);
            return true;
        }
        return false;
    }

    public void clear() {
        this.mappingSet.clear();
    }

    public String toString() {
        return this.mappingSet.toString();
    }
}

