/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.github.tomakehurst.wiremock.recording.RecordError;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

@JsonTypeInfo(use=JsonTypeInfo.Id.DEDUCTION)
@JsonSubTypes(value={@JsonSubTypes.Type(value=Full.class), @JsonSubTypes.Type(value=Ids.class)})
public class SnapshotRecordResult {
    protected final List<StubMapping> stubMappings;
    protected final List<? extends RecordError> errors;

    protected SnapshotRecordResult(List<StubMapping> mappings, List<? extends RecordError> errors) {
        this.stubMappings = mappings;
        this.errors = errors;
    }

    @JsonIgnore
    public List<StubMapping> getStubMappings() {
        return this.stubMappings;
    }

    public List<? extends RecordError> getErrors() {
        return this.errors;
    }

    public static SnapshotRecordResult full(List<StubMapping> stubMappings, List<? extends RecordError> errors) {
        return new Full(stubMappings, errors);
    }

    public static SnapshotRecordResult idsFromMappings(List<StubMapping> stubMappings, List<? extends RecordError> errors) {
        return new Ids(stubMappings.stream().map(StubMapping::getId).collect(Collectors.toList()), errors);
    }

    public static SnapshotRecordResult empty() {
        return SnapshotRecordResult.full(Collections.emptyList(), Collections.emptyList());
    }

    public static class Full
    extends SnapshotRecordResult {
        @JsonCreator
        public Full(@JsonProperty(value="mappings") List<StubMapping> mappings, @JsonProperty(value="errors") List<? extends RecordError> errors) {
            super(mappings, errors);
        }

        public List<StubMapping> getMappings() {
            return this.stubMappings;
        }
    }

    public static class Ids
    extends SnapshotRecordResult {
        private final List<UUID> ids;

        @JsonCreator
        public Ids(@JsonProperty(value="ids") List<UUID> ids, @JsonProperty(value="errors") List<? extends RecordError> errors) {
            super(Collections.emptyList(), errors);
            this.ids = ids;
        }

        public List<UUID> getIds() {
            return this.ids;
        }
    }
}

