/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;

public class ProxiedServeEventFilters
implements Predicate<ServeEvent> {
    @JsonUnwrapped
    private RequestPattern filters;
    @JsonUnwrapped
    private List<UUID> ids;
    @JsonUnwrapped
    private boolean allowNonProxied;
    public static final ProxiedServeEventFilters ALLOW_ALL = new ProxiedServeEventFilters(null, null, false);

    public ProxiedServeEventFilters() {
    }

    public ProxiedServeEventFilters(RequestPattern filters, List<UUID> ids, boolean allowNonProxied) {
        this.filters = filters;
        this.ids = ids;
        this.allowNonProxied = allowNonProxied;
    }

    public RequestPattern getFilters() {
        return this.filters;
    }

    public void setFilters(RequestPattern filters) {
        this.filters = filters;
    }

    public List<UUID> getIds() {
        return this.ids;
    }

    public void setIds(List<UUID> ids) {
        this.ids = ids;
    }

    public boolean isAllowNonProxied() {
        return this.allowNonProxied;
    }

    public void setAllowNonProxied(boolean allowNonProxied) {
        this.allowNonProxied = allowNonProxied;
    }

    @Override
    public boolean test(ServeEvent serveEvent) {
        if (!this.allowNonProxied && !serveEvent.getResponseDefinition().isProxyResponse()) {
            return false;
        }
        if (this.filters != null && !this.filters.match(serveEvent.getRequest()).isExactMatch()) {
            return false;
        }
        return this.ids == null || this.ids.contains(serveEvent.getId());
    }
}

