/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ClientError;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.JsonException;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.util.Set;

public class MatchesJsonSchemaPattern
extends StringValuePattern {
    private final JsonSchema schema;
    private final WireMock.JsonSchemaVersion schemaVersion;
    private final int schemaPropertyCount;
    private final Errors invalidSchemaErrors;

    public MatchesJsonSchemaPattern(String schemaJson) {
        this(schemaJson, WireMock.JsonSchemaVersion.V202012);
    }

    public MatchesJsonSchemaPattern(@JsonProperty(value="matchesJsonSchema") String schemaJson, @JsonProperty(value="schemaVersion") WireMock.JsonSchemaVersion schemaVersion) {
        super(schemaJson);
        Errors invalidSchemaErrors;
        int schemaPropertyCount;
        JsonSchema schema;
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        config.setTypeLoose(false);
        config.setHandleNullableField(true);
        JsonSchemaFactory schemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)schemaVersion.toVersionFlag());
        JsonNode schemaAsJson = Json.read(schemaJson, JsonNode.class);
        try {
            schema = schemaFactory.getSchema(schemaAsJson, config);
            schemaPropertyCount = Json.schemaPropertyCount(schemaAsJson);
            invalidSchemaErrors = null;
        }
        catch (Exception e) {
            schema = null;
            schemaPropertyCount = 0;
            invalidSchemaErrors = MatchesJsonSchemaPattern.getInvalidSchemaErrors(e);
        }
        this.schema = schema;
        this.schemaVersion = schemaVersion;
        this.schemaPropertyCount = schemaPropertyCount;
        this.invalidSchemaErrors = invalidSchemaErrors;
    }

    public MatchesJsonSchemaPattern(JsonNode schemaJsonNode, WireMock.JsonSchemaVersion schemaVersion) {
        this(Json.write(schemaJsonNode), schemaVersion);
    }

    public String getMatchesJsonSchema() {
        return (String)this.expectedValue;
    }

    public WireMock.JsonSchemaVersion getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    public String getExpected() {
        return Json.prettyPrint((String)this.getValue());
    }

    @Override
    public MatchResult match(String json) {
        Set<ValidationMessage> validationMessages;
        JsonNode jsonNode;
        if (this.schema == null) {
            return MatchResult.noMatch(new SubEvent("ERROR", this.invalidSchemaErrors));
        }
        if (json == null) {
            return MatchResult.noMatch(new SubEvent[0]);
        }
        try {
            jsonNode = Json.read(json, JsonNode.class);
        }
        catch (JsonException je) {
            jsonNode = new TextNode(json);
        }
        try {
            validationMessages = this.validate(jsonNode, json);
        }
        catch (Exception e) {
            return MatchResult.noMatch(new SubEvent("ERROR", MatchesJsonSchemaPattern.getInvalidSchemaErrors(e)));
        }
        if (validationMessages.isEmpty()) {
            return MatchResult.exactMatch(new SubEvent[0]);
        }
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                return false;
            }

            @Override
            public double getDistance() {
                if (MatchesJsonSchemaPattern.this.schemaPropertyCount == 0) {
                    return 1.0;
                }
                return (double)validationMessages.size() / (double)MatchesJsonSchemaPattern.this.schemaPropertyCount;
            }
        };
    }

    private static Errors getInvalidSchemaErrors(Exception e) {
        Errors invalidSchemaErrors;
        if (e instanceof ClientError) {
            Errors.Error error = ((ClientError)e).getErrors().first();
            invalidSchemaErrors = Errors.single(error.getCode(), error.getSource().getPointer(), "Invalid JSON Schema", error.getDetail());
        } else {
            invalidSchemaErrors = Errors.singleWithDetail(10, "Invalid JSON Schema", MatchesJsonSchemaPattern.getRootCause(e).getMessage());
        }
        return invalidSchemaErrors;
    }

    private static Throwable getRootCause(Throwable e) {
        if (e.getCause() != null) {
            return MatchesJsonSchemaPattern.getRootCause(e.getCause());
        }
        return e;
    }

    private Set<ValidationMessage> validate(JsonNode jsonNode, String originalJson) {
        Set validationMessages = this.schema.validate(jsonNode);
        if (validationMessages.isEmpty() || jsonNode.isTextual() || jsonNode.isContainerNode()) {
            return validationMessages;
        }
        return this.schema.validate((JsonNode)new TextNode(originalJson));
    }
}

