/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.recording.CaptureHeadersSpec;
import com.github.tomakehurst.wiremock.recording.RequestBodyPatternFactory;
import java.util.Map;
import java.util.function.Function;

class RequestPatternTransformer
implements Function<Request, RequestPatternBuilder> {
    private final Map<String, CaptureHeadersSpec> headers;
    private final RequestBodyPatternFactory bodyPatternFactory;

    RequestPatternTransformer(Map<String, CaptureHeadersSpec> headers, RequestBodyPatternFactory bodyPatternFactory) {
        this.headers = headers;
        this.bodyPatternFactory = bodyPatternFactory;
    }

    @Override
    public RequestPatternBuilder apply(Request request) {
        Map<String, QueryParameter> queryParameters = Urls.splitQueryFromUrl(request.getUrl());
        UrlPattern urlMatcher = queryParameters.isEmpty() ? WireMock.urlEqualTo(request.getUrl()) : WireMock.urlPathEqualTo(Urls.getPath(request.getUrl()));
        RequestPatternBuilder builder = new RequestPatternBuilder(request.getMethod(), urlMatcher);
        queryParameters.forEach((name, parameters) -> builder.withQueryParam((String)name, parameters.isSingleValued() ? MultiValuePattern.of(WireMock.equalTo(parameters.firstValue())) : WireMock.havingExactly(parameters.values().toArray(new String[0]))));
        if (this.headers != null && !this.headers.isEmpty()) {
            for (Map.Entry<String, CaptureHeadersSpec> header : this.headers.entrySet()) {
                String headerName = header.getKey();
                if (!request.containsHeader(headerName)) continue;
                CaptureHeadersSpec spec = header.getValue();
                EqualToPattern headerMatcher = new EqualToPattern(request.getHeader(headerName), spec.getCaseInsensitive());
                builder.withHeader(headerName, headerMatcher);
            }
        }
        byte[] body = request.getBody();
        if (this.bodyPatternFactory != null && body != null && body.length > 0) {
            builder.withRequestBody(this.bodyPatternFactory.forRequest(request));
        }
        return builder;
    }
}

