/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.common.xml.XPathException;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.common.xml.XmlDocument;
import com.github.tomakehurst.wiremock.common.xml.XmlException;
import com.github.tomakehurst.wiremock.common.xml.XmlNode;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.PathPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.XPathPatternJsonSerializer;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

@JsonSerialize(using=XPathPatternJsonSerializer.class)
public class MatchesXPathPattern
extends PathPattern {
    private final Map<String, String> xpathNamespaces;

    public MatchesXPathPattern(String xpath) {
        this(xpath, null, null);
    }

    public MatchesXPathPattern(String xpath, StringValuePattern valuePattern) {
        this(xpath, null, valuePattern);
    }

    public MatchesXPathPattern(String xpath, Map<String, String> namespaces) {
        this(xpath, namespaces, null);
    }

    public MatchesXPathPattern(@JsonProperty(value="matchesXPath") String xpath, @JsonProperty(value="namespaces") Map<String, String> namespaces, @JsonProperty(value="valuePattern") StringValuePattern valuePattern) {
        super(xpath, valuePattern);
        this.xpathNamespaces = namespaces == null || namespaces.isEmpty() ? null : namespaces;
    }

    public MatchesXPathPattern withXPathNamespace(String name, String namespaceUri) {
        HashMap<String, String> namespaceMap = new HashMap<String, String>(ParameterUtils.getFirstNonNull(this.xpathNamespaces, new HashMap()));
        namespaceMap.put(name, namespaceUri);
        return new MatchesXPathPattern((String)this.expectedValue, Collections.unmodifiableMap(namespaceMap));
    }

    public String getMatchesXPath() {
        return (String)this.expectedValue;
    }

    @JsonGetter(value="xPathNamespaces")
    public Map<String, String> getXPathNamespaces() {
        return this.xpathNamespaces;
    }

    @Override
    protected MatchResult isSimpleMatch(String value) {
        XmlNodeFindResult xmlNodeFindResult = this.findXmlNodes(value);
        ListOrSingle<XmlNode> nodeList = xmlNodeFindResult.nodes;
        return MatchResult.of(nodeList != null && !nodeList.isEmpty(), xmlNodeFindResult.subEvents);
    }

    @Override
    protected MatchResult isAdvancedMatch(String value) {
        XmlNodeFindResult xmlNodeFindResult = this.findXmlNodes(value);
        ListOrSingle<XmlNode> nodeList = xmlNodeFindResult.nodes;
        if (nodeList == null || nodeList.isEmpty()) {
            return MatchResult.noMatch(xmlNodeFindResult.subEvents);
        }
        TreeSet<MatchResult> results = new TreeSet<MatchResult>();
        for (XmlNode node : nodeList) {
            results.add(this.valuePattern.match(node.toString()));
        }
        return (MatchResult)results.last();
    }

    @Override
    public ListOrSingle<String> getExpressionResult(String value) {
        ListOrSingle<XmlNode> nodeList = this.findXmlNodes((String)value).nodes;
        if (nodeList == null || nodeList.isEmpty()) {
            return ListOrSingle.of(new String[0]);
        }
        return ListOrSingle.of(nodeList.stream().map(Object::toString).collect(Collectors.toList()));
    }

    private XmlNodeFindResult findXmlNodes(String value) {
        if (value == null || !value.trim().startsWith("<")) {
            String message = String.format("Warning: failed to parse the XML document\nXML: %s", value);
            LocalNotifier.notifier().info(message);
            return new XmlNodeFindResult(null, SubEvent.warning(message));
        }
        try {
            XmlDocument xmlDocument = Xml.parse(value);
            return new XmlNodeFindResult(xmlDocument.findNodes((String)this.expectedValue, this.xpathNamespaces), new SubEvent[0]);
        }
        catch (XmlException e) {
            String message = String.format("Warning: failed to parse the XML document. Reason: %s\nXML: %s", e.getMessage(), value);
            LocalNotifier.notifier().info(message);
            return new XmlNodeFindResult(null, SubEvent.warning(message));
        }
        catch (XPathException e) {
            String message = "Warning: failed to evaluate the XPath expression " + (String)this.expectedValue;
            LocalNotifier.notifier().info(message);
            return new XmlNodeFindResult(null, SubEvent.warning(message));
        }
    }

    private static class XmlNodeFindResult {
        final ListOrSingle<XmlNode> nodes;
        final List<SubEvent> subEvents;

        public XmlNodeFindResult(ListOrSingle<XmlNode> nodes, SubEvent ... subEvents) {
            this.nodes = nodes;
            this.subEvents = List.of(subEvents);
        }
    }
}

