/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.internal;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import org.wiremock.extensions.state.internal.model.Context;

public class ExtensionLogger {
    private ExtensionLogger() {
    }

    public static ExtensionLogger logger() {
        return InstanceHolder.instance;
    }

    public void info(Context context, String message) {
        LocalNotifier.notifier().info(this.buildMessage(context.getContextName(), message));
    }

    public void error(Context context, String message) {
        LocalNotifier.notifier().error(this.buildMessage(context.getContextName(), message));
    }

    public void info(String contextName, String message) {
        LocalNotifier.notifier().info(this.buildMessage(contextName, message));
    }

    public void error(String contextName, String message) {
        LocalNotifier.notifier().error(this.buildMessage(contextName, message));
    }

    private String buildMessage(String contextName, String message) {
        return String.format("Context '%s': %s", contextName, message);
    }

    private static final class InstanceHolder {
        private static final ExtensionLogger instance = new ExtensionLogger();

        private InstanceHolder() {
        }
    }
}

