/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state;

import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ExtensionFactory;
import com.github.tomakehurst.wiremock.extension.WireMockServices;
import com.github.tomakehurst.wiremock.store.Store;
import java.util.List;
import org.wiremock.extensions.state.extensions.DeleteStateEventListener;
import org.wiremock.extensions.state.extensions.RecordStateEventListener;
import org.wiremock.extensions.state.extensions.StateTemplateHelperProviderExtension;
import org.wiremock.extensions.state.extensions.TransactionEventListener;
import org.wiremock.extensions.state.extensions.requestmatcher.StateRequestMatcher;
import org.wiremock.extensions.state.internal.ContextManager;
import org.wiremock.extensions.state.internal.TransactionManager;

public class StateExtension
implements ExtensionFactory {
    private final Store<String, Object> store;

    public StateExtension(Store<String, Object> store) {
        this.store = store;
    }

    public List<Extension> create(WireMockServices services) {
        TransactionManager transactionManager = new TransactionManager(this.store);
        ContextManager contextManager = new ContextManager(this.store, transactionManager);
        StateTemplateHelperProviderExtension stateTemplateHelperProviderExtension = new StateTemplateHelperProviderExtension(contextManager);
        RecordStateEventListener recordStateEventListener = new RecordStateEventListener(contextManager, services);
        DeleteStateEventListener deleteStateEventListener = new DeleteStateEventListener(contextManager, services);
        TransactionEventListener transactionEventListener = new TransactionEventListener(transactionManager);
        StateRequestMatcher stateRequestMatcher = new StateRequestMatcher(contextManager, services);
        return List.of(recordStateEventListener, deleteStateEventListener, transactionEventListener, stateRequestMatcher, stateTemplateHelperProviderExtension);
    }
}

