/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.internal;

import com.github.tomakehurst.wiremock.store.Store;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.wiremock.extensions.state.internal.model.Transaction;

public class TransactionManager {
    private final String TRANSACTION_KEY_PREFIX = "transaction:";
    private final Store<String, Object> store;

    public TransactionManager(Store<String, Object> store) {
        this.store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T withTransaction(String requestId, String contextName, Function<Transaction, T> function) {
        String transactionKey = this.createTransactionKey(requestId);
        Store<String, Object> store = this.store;
        synchronized (store) {
            Map requestTransactions = this.store.get(transactionKey).map(it -> (Map)it).orElse(new HashMap());
            Transaction contextTransaction = requestTransactions.getOrDefault(contextName, new Transaction(contextName));
            Transaction t2 = function.apply(contextTransaction);
            return (T)t2;
            finally {
                requestTransactions.put(contextName, contextTransaction);
                this.store.put(transactionKey, requestTransactions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withTransaction(String requestId, String contextName, Consumer<Transaction> consumer) {
        String transactionKey = this.createTransactionKey(requestId);
        Store<String, Object> store = this.store;
        synchronized (store) {
            Map requestTransactions = this.store.get(transactionKey).map(it -> (Map)it).orElse(new HashMap());
            Transaction contextTransaction = requestTransactions.getOrDefault(contextName, new Transaction(contextName));
            try {
                consumer.accept(contextTransaction);
            }
            finally {
                requestTransactions.put(contextName, contextTransaction);
                this.store.put(transactionKey, requestTransactions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTransaction(String requestId, String contextName) {
        String transactionKey = this.createTransactionKey(requestId);
        Store<String, Object> store = this.store;
        synchronized (store) {
            Map requestTransactions = this.store.get(transactionKey).map(it -> (Map)it).orElse(new HashMap());
            requestTransactions.remove(contextName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getContextNamesByRequestId(String requestId) {
        String transactionKey = this.createTransactionKey(requestId);
        Store<String, Object> store = this.store;
        synchronized (store) {
            Map requestTransactions = this.store.get(transactionKey).map(it -> (Map)it).orElse(new HashMap());
            return requestTransactions.keySet();
        }
    }

    private String createTransactionKey(String requestId) {
        return "transaction:" + requestId;
    }
}

