/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.extensions;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.core.ConfigurationException;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.wiremock.extensions.state.internal.ContextManager;
import org.wiremock.extensions.state.internal.ExtensionLogger;
import org.wiremock.extensions.state.internal.StateExtensionMixin;
import org.wiremock.extensions.state.internal.model.Context;
import org.wiremock.extensions.state.internal.model.ContextTemplateModel;

public class StateRequestMatcher
extends RequestMatcherExtension
implements StateExtensionMixin {
    private final TemplateEngine templateEngine;
    private final ContextManager contextManager;

    public StateRequestMatcher(ContextManager contextManager, TemplateEngine templateEngine) {
        this.contextManager = contextManager;
        this.templateEngine = templateEngine;
    }

    private static List<Map.Entry<ContextMatcher, Object>> getMatchers(Parameters parameters) {
        return parameters.entrySet().stream().filter(it -> ContextMatcher.from((String)it.getKey()) != null).map(it -> Map.entry(ContextMatcher.from((String)it.getKey()), it.getValue())).collect(Collectors.toUnmodifiableList());
    }

    private static <T> T cast(Object object) {
        try {
            return (T)object;
        }
        catch (ClassCastException ex) {
            String msg = String.format("Configuration has invalid type: %s", ex.getMessage());
            String prefixed = String.format("%s: %s", "StateRequestMatcher", msg);
            LocalNotifier.notifier().error(prefixed);
            throw new ConfigurationException(prefixed);
        }
    }

    private static <T> T mapToObject(Map<String, Object> map, Class<T> klass) {
        try {
            return Json.mapToObject(map, klass);
        }
        catch (Exception ex) {
            String msg = String.format("Cannot create pattern matcher: %s", ex.getMessage());
            String prefixed = String.format("%s: %s", "StateRequestMatcher", msg);
            LocalNotifier.notifier().error(prefixed);
            throw new ConfigurationException(prefixed);
        }
    }

    @Override
    public String getName() {
        return "state-matcher";
    }

    @Override
    public MatchResult match(Request request, Parameters parameters) {
        HashMap<String, RequestTemplateModel> model = new HashMap<String, RequestTemplateModel>(Map.of("request", RequestTemplateModel.from(request)));
        return Optional.ofNullable(parameters.getString("hasContext", null)).map(template -> this.hasContext((Map<String, Object>)model, parameters, (String)template)).or(() -> Optional.ofNullable(parameters.getString("hasNotContext", null)).map(template -> this.hasNotContext(model, (String)template))).orElseThrow(() -> this.createConfigurationError("Parameters should only contain 'hasContext' or 'hasNotContext'", new String[0]));
    }

    private MatchResult hasContext(Map<String, Object> model, Parameters parameters, String template) {
        return this.contextManager.getContextCopy(this.renderTemplate(model, template)).map(context -> {
            List<Map.Entry<ContextMatcher, Object>> matchers = StateRequestMatcher.getMatchers(parameters);
            if (matchers.isEmpty()) {
                ExtensionLogger.logger().info((Context)context, "hasContext matched");
                return MatchResult.exactMatch(new SubEvent[0]);
            }
            return this.calculateMatch(model, (Context)context, matchers);
        }).orElseGet(() -> MatchResult.noMatch(new SubEvent[0]));
    }

    private MatchResult calculateMatch(Map<String, Object> model, Context context, List<Map.Entry<ContextMatcher, Object>> matchers) {
        model.put("context", ContextTemplateModel.from(context));
        List<MatchResult> results = matchers.stream().map(it -> ((ContextMatcher)((Object)((Object)it.getKey()))).evaluate(context, this.renderTemplateRecursively(model, it.getValue()))).collect(Collectors.toList());
        return MatchResult.aggregate(results);
    }

    private MatchResult hasNotContext(Map<String, Object> model, String template) {
        String context = this.renderTemplate(model, template);
        if (this.contextManager.getContextCopy(context).isEmpty()) {
            ExtensionLogger.logger().info(context, "hasNotContext matched");
            return MatchResult.exactMatch(new SubEvent[0]);
        }
        return MatchResult.noMatch(new SubEvent[0]);
    }

    String renderTemplate(Object context, String value) {
        return this.templateEngine.getUncachedTemplate(value).apply(context);
    }

    Object renderTemplateRecursively(Object context, Object value) {
        if (value instanceof Collection) {
            Collection castedCollection = (Collection)StateRequestMatcher.cast(value);
            return castedCollection.stream().map(it -> this.renderTemplateRecursively(context, it)).collect(Collectors.toList());
        }
        if (value instanceof Map) {
            HashMap newMap = new HashMap();
            Map castedMap = (Map)StateRequestMatcher.cast(value);
            castedMap.forEach((k, v) -> newMap.put(this.renderTemplate(context, (String)k), this.renderTemplateRecursively(context, v)));
            return newMap;
        }
        return this.renderTemplate(context, value.toString());
    }

    private static enum ContextMatcher {
        property((c, object) -> {
            Map mapValue = (Map)StateRequestMatcher.cast(object);
            List<MatchResult> results = mapValue.entrySet().stream().map(entry -> {
                StringValuePattern patterns = StateRequestMatcher.mapToObject((Map)entry.getValue(), StringValuePattern.class);
                String propertyValue = c.getProperties().get(entry.getKey());
                return patterns.match(propertyValue);
            }).collect(Collectors.toList());
            if (results.isEmpty()) {
                ExtensionLogger.logger().info((Context)c, "No interpretable matcher was found, defaulting to 'exactMatch'");
                return MatchResult.exactMatch(new SubEvent[0]);
            }
            return MatchResult.aggregate(results);
        }),
        list((c, object) -> {
            Map mapValue = (Map)StateRequestMatcher.cast(object);
            List<MatchResult> allResults = mapValue.entrySet().stream().map(listIndexEntry -> {
                Map listEntry;
                switch ((String)listIndexEntry.getKey()) {
                    case "last": 
                    case "-1": {
                        listEntry = c.getList().getLast();
                        break;
                    }
                    case "first": {
                        listEntry = c.getList().getFirst();
                        break;
                    }
                    default: {
                        listEntry = ContextMatcher.withConvertedNumberGet(c, (String)listIndexEntry.getKey(), (context, value) -> c.getList().get(value.intValue()));
                    }
                }
                if (listEntry == null) {
                    return MatchResult.noMatch(new SubEvent[0]);
                }
                List<MatchResult> results = ((Map)listIndexEntry.getValue()).entrySet().stream().map(entry -> {
                    StringValuePattern patterns = StateRequestMatcher.mapToObject((Map)entry.getValue(), StringValuePattern.class);
                    String propertyValue = (String)listEntry.get(entry.getKey());
                    return patterns.match(propertyValue);
                }).collect(Collectors.toList());
                if (results.isEmpty()) {
                    ExtensionLogger.logger().info((Context)c, "No interpretable matcher was found, defaulting to 'exactMatch'");
                    return MatchResult.exactMatch(new SubEvent[0]);
                }
                return MatchResult.aggregate(results);
            }).collect(Collectors.toList());
            return MatchResult.aggregate(allResults);
        }),
        hasProperty((c, object) -> {
            String stringValue = (String)StateRequestMatcher.cast(object);
            return ContextMatcher.toMatchResult(c.getProperties().containsKey(stringValue));
        }),
        hasNotProperty((c, object) -> {
            String stringValue = (String)StateRequestMatcher.cast(object);
            return ContextMatcher.toMatchResult(!c.getProperties().containsKey(stringValue));
        }),
        updateCountEqualTo((c, object) -> {
            String stringValue = (String)StateRequestMatcher.cast(object);
            return ContextMatcher.toMatchResult(ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> context.getUpdateCount().equals(value)));
        }),
        updateCountLessThan((c, object) -> {
            String stringValue = (String)StateRequestMatcher.cast(object);
            return ContextMatcher.toMatchResult(ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> context.getUpdateCount() < value));
        }),
        updateCountMoreThan((c, object) -> {
            String stringValue = (String)StateRequestMatcher.cast(object);
            return ContextMatcher.toMatchResult(ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> context.getUpdateCount() > value));
        }),
        listSizeEqualTo((c, object) -> {
            String stringValue = (String)StateRequestMatcher.cast(object);
            return ContextMatcher.toMatchResult(ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> (long)context.getList().size() == value));
        }),
        listSizeLessThan((c, object) -> {
            String stringValue = (String)StateRequestMatcher.cast(object);
            return ContextMatcher.toMatchResult(ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> (long)context.getList().size() < value));
        }),
        listSizeMoreThan((c, object) -> {
            String stringValue = (String)StateRequestMatcher.cast(object);
            return ContextMatcher.toMatchResult(ContextMatcher.withConvertedNumber(c, stringValue, (context, value) -> (long)context.getList().size() > value));
        });

        private final BiFunction<Context, Object, MatchResult> evaluator;

        private ContextMatcher(BiFunction<Context, Object, MatchResult> evaluator) {
            this.evaluator = evaluator;
        }

        private static MatchResult toMatchResult(boolean result) {
            return result ? MatchResult.exactMatch(new SubEvent[0]) : MatchResult.noMatch(new SubEvent[0]);
        }

        public static ContextMatcher from(String from) {
            return Arrays.stream(ContextMatcher.values()).filter(it -> it.name().equals(from)).findFirst().orElse(null);
        }

        private static boolean withConvertedNumber(Context context, String stringValue, BiFunction<Context, Long, Boolean> evaluator) {
            try {
                Long longValue = Long.valueOf(stringValue);
                return evaluator.apply(context, longValue);
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }

        private static <T> T withConvertedNumberGet(Context context, String stringValue, BiFunction<Context, Long, T> getter) {
            try {
                Long longValue = Long.valueOf(stringValue);
                return getter.apply(context, longValue);
            }
            catch (IndexOutOfBoundsException | NumberFormatException ex) {
                return null;
            }
        }

        public MatchResult evaluate(Context context, Object value) {
            return this.evaluator.apply(context, value);
        }
    }
}

