/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.exceptions.ConfigurationException;
import org.custommonkey.xmlunit.exceptions.XMLUnitRuntimeException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.Input;
import org.xmlunit.transform.Transformation;

public class Transform {
    private static final File PWD = new File(".");
    private final Transformation transformation;
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    public Transform(String input, String stylesheet) {
        this(input == null ? null : Input.fromString(input), stylesheet == null ? null : Input.fromString(stylesheet));
    }

    public Transform(String input, File stylesheet) {
        this(input == null ? null : Input.fromString(input), stylesheet == null ? null : Input.fromFile(stylesheet));
    }

    public Transform(InputSource input, InputSource stylesheet) {
        this(new SAXSource(input), new SAXSource(stylesheet));
    }

    public Transform(InputSource input, File stylesheet) {
        this(new SAXSource(input), stylesheet == null ? null : Input.fromFile(stylesheet).build());
    }

    public Transform(Node sourceNode) {
        this(sourceNode, (String)null);
    }

    public Transform(Node sourceNode, String stylesheet) {
        this(sourceNode == null ? null : Input.fromNode(sourceNode), stylesheet == null ? null : Input.fromString(stylesheet));
    }

    public Transform(Node sourceNode, File stylesheet) {
        this(sourceNode == null ? null : Input.fromNode(sourceNode), stylesheet == null ? null : Input.fromFile(stylesheet));
    }

    private Transform(Input.Builder input, Input.Builder stylesheet) {
        this(input == null ? null : input.build(), stylesheet == null ? null : stylesheet.build());
    }

    public Transform(Source inputSource, Source stylesheetSource) {
        this.transformation = new Transformation(inputSource);
        this.transformation.setStylesheet(stylesheetSource);
        this.transformation.setFactory(XMLUnit.getTransformerFactory());
        this.provideSystemIdIfRequired(inputSource);
        this.provideSystemIdIfRequired(stylesheetSource);
    }

    private void provideSystemIdIfRequired(Source source) {
        if (source != null && (source.getSystemId() == null || source.getSystemId().length() == 0)) {
            source.setSystemId(this.getDefaultSystemId());
        }
    }

    private String getDefaultSystemId() {
        try {
            return PWD.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new XMLUnitRuntimeException("Unable to determine current working directory!", e);
        }
    }

    protected void transformTo(final Result result) throws TransformerException {
        Transform.withExceptionHandling(new Trans<Object>(){

            @Override
            public Object transform() {
                Transform.this.transformation.transformTo(result);
                return null;
            }
        });
    }

    public String getResultString() throws TransformerException {
        return Transform.withExceptionHandling(new Trans<String>(){

            @Override
            public String transform() {
                return Transform.this.transformation.transformToString();
            }
        });
    }

    public Document getResultDocument() throws TransformerException {
        return Transform.withExceptionHandling(new Trans<Document>(){

            @Override
            public Document transform() {
                return Transform.this.transformation.transformToDocument();
            }
        });
    }

    public void setOutputProperty(String name, String value) {
        this.transformation.addOutputProperty(name, value);
    }

    public void setOutputProperties(Properties outputProperties) {
        Enumeration<?> e = outputProperties.propertyNames();
        while (e.hasMoreElements()) {
            String name;
            String value;
            Object key = e.nextElement();
            if (key == null || (value = outputProperties.getProperty(name = key.toString())) == null) continue;
            this.setOutputProperty(name, value);
        }
    }

    public void setParameter(String name, Object value) {
        this.parameters.put(name, value);
        this.transformation.addParameter(name, value);
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public void clearParameters() {
        this.parameters.clear();
        this.transformation.clearParameters();
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.transformation.setURIResolver(uriResolver);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.transformation.setErrorListener(errorListener);
    }

    static <R> R withExceptionHandling(Trans<R> trans) throws TransformerException {
        try {
            return trans.transform();
        }
        catch (org.xmlunit.ConfigurationException ex) {
            throw new ConfigurationException(ex.getMessage(), ex.getCause());
        }
        catch (XMLUnitException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof TransformerException) {
                throw (TransformerException)cause;
            }
            throw new XMLUnitRuntimeException(ex.getMessage(), cause);
        }
    }

    static interface Trans<R> {
        public R transform();
    }
}

