/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ReadOnlyValidator.class);
    private final boolean readOnly;

    public ReadOnlyValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.READ_ONLY, validationContext);
        this.readOnly = validationContext.getConfig().isReadOnly();
        logger.debug("Loaded ReadOnlyValidator for property {} as {}", (Object)parentSchema, (Object)"read mode");
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        ReadOnlyValidator.debug(logger, node, rootNode, at);
        HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
        if (this.readOnly) {
            errors.add(this.buildValidationMessage(at, new String[0]));
        }
        return errors;
    }
}

