/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.requestfilter;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.ParameterUtils;
import com.github.tomakehurst.wiremock.extension.requestfilter.FieldTransformer;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.FormParameter;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RequestWrapper
implements Request {
    private final Request delegate;
    private final RequestMethod method;
    private final FieldTransformer<String> absoluteUrlTransformer;
    private final List<HttpHeader> addedHeaders;
    private final List<String> removedHeaders;
    private final Map<CaseInsensitiveKey, FieldTransformer<List<String>>> headerTransformers;
    private final Map<String, Cookie> additionalCookies;
    private final List<String> cookiesToRemove;
    private final Map<String, FieldTransformer<Cookie>> cookieTransformers;
    private final FieldTransformer<Body> bodyTransformer;
    private final FieldTransformer<Request.Part> multipartTransformer;

    public RequestWrapper(Request delegate) {
        this(delegate, null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap(), null, null);
    }

    public RequestWrapper(Request delegate, RequestMethod method, FieldTransformer<String> absoluteUrlTransformer, List<HttpHeader> addedHeaders, List<String> removedHeaders, Map<CaseInsensitiveKey, FieldTransformer<List<String>>> headerTransformers, Map<String, Cookie> additionalCookies, List<String> cookiesToRemove, Map<String, FieldTransformer<Cookie>> cookieTransformers, FieldTransformer<Body> bodyTransformer, FieldTransformer<Request.Part> multipartTransformer) {
        this.delegate = delegate;
        this.method = method;
        this.absoluteUrlTransformer = absoluteUrlTransformer;
        this.addedHeaders = addedHeaders;
        this.removedHeaders = removedHeaders;
        this.headerTransformers = headerTransformers;
        this.additionalCookies = additionalCookies;
        this.cookiesToRemove = cookiesToRemove;
        this.cookieTransformers = cookieTransformers;
        this.bodyTransformer = bodyTransformer;
        this.multipartTransformer = multipartTransformer;
    }

    public static Builder create() {
        return new Builder();
    }

    @Override
    public String getUrl() {
        String absoluteUrl = this.getAbsoluteUrl();
        int relativeStartIndex = StringUtils.countMatches((CharSequence)absoluteUrl, "/") >= 3 ? StringUtils.ordinalIndexOf(absoluteUrl, "/", 3) : absoluteUrl.length();
        return absoluteUrl.substring(relativeStartIndex);
    }

    @Override
    public String getAbsoluteUrl() {
        if (this.absoluteUrlTransformer != null) {
            return this.absoluteUrlTransformer.transform(this.delegate.getAbsoluteUrl());
        }
        return this.delegate.getAbsoluteUrl();
    }

    @Override
    public RequestMethod getMethod() {
        return ParameterUtils.getFirstNonNull(this.method, this.delegate.getMethod());
    }

    @Override
    public String getScheme() {
        return this.delegate.getScheme();
    }

    @Override
    public String getHost() {
        return this.delegate.getHost();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public String getClientIp() {
        return this.delegate.getClientIp();
    }

    @Override
    public String getHeader(String key) {
        return this.getHeaders().getHeader(key).firstValue();
    }

    @Override
    public HttpHeader header(String key) {
        return this.getHeaders().getHeader(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.delegate.contentTypeHeader();
    }

    @Override
    public HttpHeaders getHeaders() {
        ArrayList<HttpHeader> existingHeaders = new ArrayList<HttpHeader>(this.delegate.getHeaders().all());
        existingHeaders.addAll(this.addedHeaders);
        List<HttpHeader> combinedHeaders = existingHeaders.stream().filter(httpHeader -> !this.removedHeaders.contains(httpHeader.key())).map(httpHeader -> {
            if (this.headerTransformers.containsKey(httpHeader.caseInsensitiveKey())) {
                FieldTransformer<List<String>> transformer = this.headerTransformers.get(httpHeader.caseInsensitiveKey());
                List<String> newValues = transformer.transform(httpHeader.values());
                return new HttpHeader(httpHeader.key(), (Collection<String>)newValues);
            }
            return httpHeader;
        }).collect(Collectors.toList());
        return new HttpHeaders(combinedHeaders);
    }

    @Override
    public boolean containsHeader(String key) {
        return this.getHeaders().keys().contains(key);
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        return this.getHeaders().keys();
    }

    @Override
    public Map<String, Cookie> getCookies() {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        for (Map.Entry<String, Cookie> entry : this.delegate.getCookies().entrySet()) {
            Cookie newCookie;
            Cookie cookie = newCookie = this.cookieTransformers.containsKey(entry.getKey()) ? this.cookieTransformers.get(entry.getKey()).transform(entry.getValue()) : entry.getValue();
            if (this.cookiesToRemove.contains(entry.getKey())) continue;
            cookieMap.put(entry.getKey(), newCookie);
        }
        cookieMap.putAll(this.additionalCookies);
        return Collections.unmodifiableMap(cookieMap);
    }

    @Override
    public QueryParameter queryParameter(String key) {
        return this.delegate.queryParameter(key);
    }

    @Override
    public FormParameter formParameter(String key) {
        return this.delegate.formParameter(key);
    }

    @Override
    public Map<String, FormParameter> formParameters() {
        return this.delegate.formParameters();
    }

    @Override
    public byte[] getBody() {
        if (this.bodyTransformer != null) {
            return this.bodyTransformer.transform(new Body(this.delegate.getBody())).asBytes();
        }
        return this.delegate.getBody();
    }

    @Override
    public String getBodyAsString() {
        if (this.bodyTransformer != null) {
            return this.bodyTransformer.transform(new Body(this.delegate.getBodyAsString())).asString();
        }
        return this.delegate.getBodyAsString();
    }

    @Override
    public String getBodyAsBase64() {
        return Encoding.encodeBase64(this.getBody());
    }

    @Override
    public boolean isMultipart() {
        return this.delegate.isMultipart();
    }

    @Override
    public Collection<Request.Part> getParts() {
        if (this.delegate.getParts() == null || this.multipartTransformer == null) {
            return this.delegate.getParts();
        }
        return this.delegate.getParts().stream().map(this.multipartTransformer::transform).collect(Collectors.toList());
    }

    @Override
    public Request.Part getPart(String name) {
        if (this.multipartTransformer != null) {
            return this.multipartTransformer.transform(this.delegate.getPart(name));
        }
        return this.delegate.getPart(name);
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return this.delegate.isBrowserProxyRequest();
    }

    @Override
    public Optional<Request> getOriginalRequest() {
        return this.delegate.getOriginalRequest();
    }

    @Override
    public String getProtocol() {
        return this.delegate.getProtocol();
    }

    public static class Builder {
        private RequestMethod requestMethod;
        private FieldTransformer<String> absoluteUrlTransformer;
        private final List<HttpHeader> additionalHeaders = new ArrayList<HttpHeader>();
        private final List<String> headersToRemove = new ArrayList<String>();
        private final Map<CaseInsensitiveKey, FieldTransformer<List<String>>> headerTransformers = new HashMap<CaseInsensitiveKey, FieldTransformer<List<String>>>();
        private final Map<String, Cookie> additionalCookies = new HashMap<String, Cookie>();
        private final List<String> cookiesToRemove = new ArrayList<String>();
        private final Map<String, FieldTransformer<Cookie>> cookieTransformers = new HashMap<String, FieldTransformer<Cookie>>();
        private FieldTransformer<Body> bodyTransformer;
        private FieldTransformer<Request.Part> mutlipartTransformer;

        public Builder addHeader(String key, String ... values) {
            this.additionalHeaders.add(new HttpHeader(key, values));
            return this;
        }

        public Builder removeHeader(String key) {
            this.headersToRemove.add(key);
            return this;
        }

        public Builder transformHeader(String key, FieldTransformer<List<String>> transformer) {
            this.headerTransformers.put(CaseInsensitiveKey.from(key), transformer);
            return this;
        }

        public Builder setMethod(RequestMethod method) {
            this.requestMethod = method;
            return this;
        }

        public Builder transformAbsoluteUrl(FieldTransformer<String> transformer) {
            this.absoluteUrlTransformer = transformer;
            return this;
        }

        public Request wrap(Request request) {
            return new RequestWrapper(request, this.requestMethod, this.absoluteUrlTransformer, this.additionalHeaders, this.headersToRemove, this.headerTransformers, this.additionalCookies, this.cookiesToRemove, this.cookieTransformers, this.bodyTransformer, this.mutlipartTransformer);
        }

        public Builder transformBody(FieldTransformer<Body> transformer) {
            this.bodyTransformer = transformer;
            return this;
        }

        public Builder transformCookie(String name, FieldTransformer<Cookie> transformer) {
            this.cookieTransformers.put(name, transformer);
            return this;
        }

        public Builder transformParts(FieldTransformer<Request.Part> transformer) {
            this.mutlipartTransformer = transformer;
            return this;
        }

        public Builder addCookie(String name, Cookie value) {
            this.additionalCookies.put(name, value);
            return this;
        }

        public Builder removeCookie(String name) {
            this.cookiesToRemove.add(name);
            return this;
        }
    }
}

