/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.internal.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;

public class Context {
    private final String contextName;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final LinkedList<Map<String, String>> list = new LinkedList();
    private final LinkedList<String> requests = new LinkedList();
    private Long updateCount = 0L;

    public Context(Context other) {
        this.contextName = other.contextName;
        this.properties.putAll(other.properties);
        this.list.addAll(other.list.stream().map(HashMap::new).collect(Collectors.toList()));
        this.requests.addAll(other.requests);
        this.updateCount = other.updateCount;
    }

    public Context(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Long getUpdateCount() {
        return this.updateCount;
    }

    public Long incUpdateCount() {
        this.updateCount = this.updateCount + 1L;
        return this.updateCount;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public LinkedList<Map<String, String>> getList() {
        return this.list;
    }

    public String toString() {
        return "Context{contextName='" + this.contextName + "', properties=" + String.valueOf(this.properties) + ", list=" + String.valueOf(this.list) + ", updateCount=" + this.updateCount + "}";
    }
}

