/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.extensions;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.core.ConfigurationException;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.extension.WireMockServices;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.wiremock.extensions.state.internal.ContextManager;
import org.wiremock.extensions.state.internal.ExtensionLogger;
import org.wiremock.extensions.state.internal.StateExtensionMixin;
import org.wiremock.extensions.state.internal.api.DeleteStateParameters;
import org.wiremock.extensions.state.internal.model.ResponseTemplateModel;
import wiremock.org.apache.commons.lang3.StringUtils;

public class DeleteStateEventListener
implements ServeEventListener,
StateExtensionMixin {
    private final WireMockServices wireMockServices;
    private final ContextManager contextManager;

    public DeleteStateEventListener(ContextManager contextManager, WireMockServices services) {
        this.contextManager = contextManager;
        this.wireMockServices = services;
    }

    public String getName() {
        return "deleteState";
    }

    public boolean applyGlobally() {
        return false;
    }

    public void beforeResponseSent(ServeEvent serveEvent, Parameters parameters) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(this.wireMockServices.getTemplateEngine().buildModelForRequest(serveEvent));
        model.put("response", ResponseTemplateModel.from(serveEvent.getResponse()));
        DeleteStateParameters configuration = (DeleteStateParameters)Json.mapToObject((Map)parameters, DeleteStateParameters.class);
        new ListenerInstance(serveEvent.getId().toString(), model, configuration).run();
    }

    private String renderTemplate(Object context, String value) {
        return this.wireMockServices.getTemplateEngine().getUncachedTemplate(value).apply(context);
    }

    private class ListenerInstance {
        private final String requestId;
        private final DeleteStateParameters configuration;
        private final Map<String, Object> model;

        ListenerInstance(String requestId, Map<String, Object> model, DeleteStateParameters configuration) {
            this.requestId = requestId;
            this.model = model;
            this.configuration = configuration;
        }

        public void run() {
            Optional.ofNullable(this.configuration.getList()).ifPresentOrElse(listConfig -> this.handleListDeletion((DeleteStateParameters.ListParameters)listConfig, this.createContextName(this.configuration.getContext())), this::handleContextDeletion);
        }

        private void handleContextDeletion() {
            if (this.configuration.getContext() != null) {
                this.deleteContext(this.configuration.getContext());
            } else if (this.configuration.getContexts() != null) {
                this.deleteContexts(this.configuration.getContexts());
            } else if (this.configuration.getContextsMatching() != null) {
                this.deleteContextsMatching(this.configuration.getContextsMatching());
            } else {
                throw DeleteStateEventListener.this.createConfigurationError("Missing/invalid configuration for context deletion", new String[0]);
            }
        }

        private void deleteContexts(List<String> rawContexts) {
            List contexts = rawContexts.stream().map(it -> DeleteStateEventListener.this.renderTemplate(this.model, (String)it)).collect(Collectors.toList());
            DeleteStateEventListener.this.contextManager.onEach(this.requestId, context -> {
                if (contexts.contains(context.getContextName())) {
                    DeleteStateEventListener.this.contextManager.deleteContext(this.requestId, context.getContextName());
                }
            });
        }

        private void deleteContextsMatching(String rawRegex) {
            try {
                String regex = DeleteStateEventListener.this.renderTemplate(this.model, rawRegex);
                Pattern pattern = Pattern.compile(regex);
                DeleteStateEventListener.this.contextManager.onEach(this.requestId, context -> {
                    if (pattern.matcher(context.getContextName()).matches()) {
                        DeleteStateEventListener.this.contextManager.deleteContext(this.requestId, context.getContextName());
                    }
                });
            }
            catch (PatternSyntaxException ex) {
                throw DeleteStateEventListener.this.createConfigurationError("Missing/invalid configuration for context deletion: %s", new String[]{ex.getMessage()});
            }
        }

        private void deleteContext(String rawContext) {
            DeleteStateEventListener.this.contextManager.deleteContext(this.requestId, this.createContextName(rawContext));
        }

        private void handleListDeletion(DeleteStateParameters.ListParameters listConfig, String contextName) {
            if (Boolean.TRUE.equals(listConfig.getDeleteFirst())) {
                this.deleteFirst(contextName);
            } else if (Boolean.TRUE.equals(listConfig.getDeleteLast())) {
                this.deleteLast(contextName);
            } else if (StringUtils.isNotBlank(listConfig.getDeleteIndex())) {
                this.deleteIndex(listConfig, contextName);
            } else if (listConfig.getDeleteWhere() != null && listConfig.getDeleteWhere().getProperty() != null && listConfig.getDeleteWhere().getValue() != null) {
                this.deleteWhere(listConfig, contextName);
            } else {
                throw DeleteStateEventListener.this.createConfigurationError("Missing/invalid configuration for list entry deletion", new String[0]);
            }
        }

        private void deleteFirst(String contextName) {
            DeleteStateEventListener.this.contextManager.createOrUpdateContextList(this.requestId, contextName, maps -> {
                if (!maps.isEmpty()) {
                    maps.removeFirst();
                }
                ExtensionLogger.logger().info(contextName, "list::deleteFirst");
            });
        }

        private void deleteLast(String contextName) {
            DeleteStateEventListener.this.contextManager.createOrUpdateContextList(this.requestId, contextName, maps -> {
                if (!maps.isEmpty()) {
                    maps.removeLast();
                }
                ExtensionLogger.logger().info(contextName, "list::deleteLast");
            });
        }

        private void deleteIndex(DeleteStateParameters.ListParameters listConfig, String contextName) {
            try {
                int index = Integer.parseInt(DeleteStateEventListener.this.renderTemplate(this.model, listConfig.getDeleteIndex()));
                DeleteStateEventListener.this.contextManager.createOrUpdateContextList(this.requestId, contextName, list -> {
                    list.remove(index);
                    ExtensionLogger.logger().info(contextName, String.format("list::deleteIndex(%d)", index));
                });
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                ExtensionLogger.logger().info(contextName, String.format("Unknown or unparsable list index: '%s' - ignoring", listConfig.getDeleteIndex()));
            }
        }

        private void deleteWhere(DeleteStateParameters.ListParameters listConfig, String contextName) {
            String property = DeleteStateEventListener.this.renderTemplate(this.model, listConfig.getDeleteWhere().getProperty());
            String value = DeleteStateEventListener.this.renderTemplate(this.model, listConfig.getDeleteWhere().getValue());
            DeleteStateEventListener.this.contextManager.createOrUpdateContextList(this.requestId, contextName, list -> {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Map element = (Map)iterator.next();
                    if (!Objects.equals(element.getOrDefault(property, null), value)) continue;
                    iterator.remove();
                    ExtensionLogger.logger().info(contextName, String.format("list::deleteWhere(property=%s)", property));
                    break;
                }
            });
        }

        private String createContextName(String rawContext) {
            String context = Optional.ofNullable(rawContext).filter(StringUtils::isNotBlank).map(it -> DeleteStateEventListener.this.renderTemplate(this.model, (String)it)).orElseThrow(() -> new ConfigurationException("No context specified"));
            if (StringUtils.isBlank(context)) {
                throw DeleteStateEventListener.this.createConfigurationError("Context cannot be blank", new String[0]);
            }
            return context;
        }
    }
}

