/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.extensions;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Set;
import org.wiremock.extensions.state.internal.StateExtensionMixin;
import org.wiremock.extensions.state.internal.TransactionManager;

public class TransactionEventListener
implements ServeEventListener,
StateExtensionMixin {
    private final TransactionManager transactionManager;

    public TransactionEventListener(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getName() {
        return "stateTransaction";
    }

    public boolean applyGlobally() {
        return true;
    }

    public void afterComplete(ServeEvent serveEvent, Parameters parameters) {
        String requestId = serveEvent.getId().toString();
        Set<String> contextNames = this.transactionManager.getContextNamesByRequestId(requestId);
        contextNames.forEach(contextName -> this.transactionManager.deleteTransaction(requestId, (String)contextName));
    }
}

