/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.internal;

import com.github.tomakehurst.wiremock.store.Store;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.wiremock.extensions.state.internal.model.Transaction;

public class TransactionManager {
    private final String TRANSACTION_KEY_PREFIX = "transaction:";
    private final Store<String, Object> store;

    public TransactionManager(Store<String, Object> store) {
        this.store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withTransaction(String requestId, String contextName, Consumer<Transaction> consumer) {
        String transactionKey = this.createTransactionKey(requestId);
        Store<String, Object> store = this.store;
        synchronized (store) {
            Map requestTransactions = this.store.get(transactionKey).map(it -> (Map)it).orElse(new HashMap());
            Transaction contextTransaction = requestTransactions.getOrDefault(contextName, new Transaction(contextName));
            try {
                consumer.accept(contextTransaction);
            }
            finally {
                requestTransactions.put(contextName, contextTransaction);
                this.store.put(transactionKey, requestTransactions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTransaction(String requestId, String contextName) {
        String transactionKey = this.createTransactionKey(requestId);
        Store<String, Object> store = this.store;
        synchronized (store) {
            Map requestTransactions = this.store.get(transactionKey).map(it -> (Map)it).orElse(new HashMap());
            requestTransactions.remove(contextName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getContextNamesByRequestId(String requestId) {
        String transactionKey = this.createTransactionKey(requestId);
        Store<String, Object> store = this.store;
        synchronized (store) {
            Map requestTransactions = this.store.get(transactionKey).map(it -> (Map)it).orElse(new HashMap());
            return new HashSet<String>(requestTransactions.keySet());
        }
    }

    private String createTransactionKey(String requestId) {
        return "transaction:" + requestId;
    }
}

