/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.internal;

import com.github.tomakehurst.wiremock.store.Store;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.wiremock.extensions.state.internal.ExtensionLogger;
import org.wiremock.extensions.state.internal.TransactionManager;
import org.wiremock.extensions.state.internal.model.Context;

public class ContextManager {
    private final String CONTEXT_KEY_PREFIX = "context:";
    private final Store<String, Object> store;
    private final TransactionManager transactionManager;

    public ContextManager(Store<String, Object> store, TransactionManager transactionManager) {
        this.store = store;
        this.transactionManager = transactionManager;
    }

    private static Supplier<Context> createNewContext(String contextName) {
        ExtensionLogger.logger().info(contextName, "created");
        return () -> new Context(contextName);
    }

    public Optional<Context> getContextCopy(String contextName) {
        return this.getSafeContextCopy(contextName);
    }

    public void deleteContext(String requestId, String contextName) {
        this.transactionManager.withTransaction(requestId, contextName, transaction -> {
            this.store.remove(this.createContextKey(contextName));
            ExtensionLogger.logger().info(contextName, "deleted");
        });
    }

    public void onEach(String requestId, Consumer<Context> consumer) {
        this.store.getAllKeys().filter(it -> it.startsWith("context:")).forEach(key -> {
            String contextName = this.getContextNameFromContextKey((String)key);
            this.transactionManager.withTransaction(requestId, contextName, transaction -> this.getSafeContextCopy(contextName).ifPresent(consumer));
        });
    }

    public void deleteAllContexts(String requestId) {
        this.store.getAllKeys().filter(it -> it.startsWith("context:")).forEach(key -> {
            this.transactionManager.withTransaction(requestId, this.getContextNameFromContextKey((String)key), transaction -> this.store.remove((String)key));
            ExtensionLogger.logger().info("allContexts", "deleted");
        });
    }

    public void createOrUpdateContextState(String requestId, String contextName, Map<String, String> properties) {
        this.transactionManager.withTransaction(requestId, contextName, transaction -> {
            String contextKey = this.createContextKey(contextName);
            Context context = this.store.get(contextKey).map(it -> (Context)it).orElseGet(ContextManager.createNewContext(contextName));
            properties.forEach((k, v) -> {
                if (v.equals("null")) {
                    context.getProperties().remove(k);
                    ExtensionLogger.logger().info(contextName, String.format("property '%s' removed", k));
                } else {
                    context.getProperties().put((String)k, (String)v);
                    ExtensionLogger.logger().info(contextName, String.format("property '%s' updated", k));
                }
            });
            transaction.recordWrite(context::incUpdateCount);
            this.store.put(contextKey, context);
        });
    }

    public void createOrUpdateContextList(String requestId, String contextName, Consumer<LinkedList<Map<String, String>>> consumer) {
        this.transactionManager.withTransaction(requestId, contextName, transaction -> {
            String contextKey = this.createContextKey(contextName);
            Context context = this.store.get(contextKey).map(it -> (Context)it).orElseGet(ContextManager.createNewContext(contextName));
            consumer.accept(context.getList());
            transaction.recordWrite(context::incUpdateCount);
            this.store.put(contextKey, context);
        });
    }

    public Long numUpdates(String contextName) {
        return this.store.get(this.createContextKey(contextName)).map(it -> ((Context)it).getUpdateCount()).orElse(0L);
    }

    private String getContextNameFromContextKey(String key) {
        return key.substring("context:".length());
    }

    public String createContextKey(String contextName) {
        return "context:" + contextName;
    }

    private Optional<Context> getSafeContextCopy(String contextName) {
        return this.store.get(this.createContextKey(contextName)).map(it -> (Context)it).map(Context::new);
    }
}

