/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.Notifier;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConsoleNotifier
implements Notifier {
    private final boolean verbose;
    private final String prefix;

    public ConsoleNotifier(boolean verbose) {
        this(null, verbose);
    }

    public ConsoleNotifier(String name, boolean verbose) {
        this.verbose = verbose;
        Object object = this.prefix = name != null ? "[" + name + "] " : "";
        if (verbose) {
            this.info("Verbose logging enabled");
        }
    }

    @Override
    public void info(String message) {
        if (this.verbose) {
            System.out.println(this.formatMessage(message));
        }
    }

    @Override
    public void error(String message) {
        System.err.println(this.formatMessage(message));
    }

    @Override
    public void error(String message, Throwable t2) {
        System.err.println(this.formatMessage(message));
        t2.printStackTrace(System.err);
    }

    private String formatMessage(String message) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String date = df.format(new Date());
        return String.format("%s%s %s", this.prefix, date, message);
    }
}

