/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;

public class Conversions {
    public static Integer toInt(QueryParameter parameter) {
        return parameter.isPresent() ? Integer.valueOf(parameter.firstValue()) : null;
    }

    public static Date toDate(QueryParameter parameter) {
        try {
            return parameter.isPresent() ? Date.from(ZonedDateTime.parse(parameter.firstValue()).toInstant()) : null;
        }
        catch (DateTimeParseException e) {
            throw new InvalidInputException(Errors.validation(parameter.key(), parameter.firstValue() + " is not a valid ISO8601 date"));
        }
    }
}

