/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;

public class Context {
    private static final int MAX_IDS = 10;
    private final String contextName;
    private final Map<String, String> properties = new HashMap<String, String>();
    private final LinkedList<Map<String, String>> list = new LinkedList();
    private final LinkedList<String> requests = new LinkedList();
    private Long updateCount = 1L;
    private Long matchCount = 0L;

    public Context(Context other) {
        this.contextName = other.contextName;
        this.properties.putAll(other.properties);
        this.list.addAll(other.list.stream().map(HashMap::new).collect(Collectors.toList()));
        this.requests.addAll(other.requests);
        this.updateCount = other.updateCount;
        this.matchCount = other.matchCount;
    }

    public Context(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Long getUpdateCount() {
        return this.updateCount;
    }

    public Long getMatchCount() {
        return this.matchCount;
    }

    public Long incUpdateCount() {
        this.updateCount = this.updateCount + 1L;
        return this.updateCount;
    }

    public Long incMatchCount(String requestId) {
        if (this.requests.contains(requestId)) {
            return this.matchCount;
        }
        this.requests.add(requestId);
        if (this.requests.size() > 10) {
            this.requests.removeFirst();
        }
        this.matchCount = this.matchCount + 1L;
        return this.matchCount;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public LinkedList<Map<String, String>> getList() {
        return this.list;
    }

    public String toString() {
        return "Context{contextName='" + this.contextName + "', properties=" + this.properties + ", list=" + this.list + ", updateCount=" + this.updateCount + "}";
    }
}

