/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.RequiredValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private static final String DISCRIMINATOR_REMARK = "and the discriminator-selected candidate schema didn't pass validation";
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();
    private final ValidationContext.DiscriminatorContext discriminatorContext;

    public AnyOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ANY_OF, validationContext);
        this.validationContext = validationContext;
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(validationContext.newSchema(schemaPath + "/" + i, schemaNode.get(i), parentSchema));
        }
        this.discriminatorContext = this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() ? new ValidationContext.DiscriminatorContext() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        AnyOfValidator.debug(AnyOfValidator.logger, node, rootNode, at);
        collectorContext = CollectorContext.getInstance();
        state = (ValidatorState)collectorContext.get("com.networknt.schema.ValidatorState");
        if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
            this.validationContext.enterDiscriminatorContext(this.discriminatorContext, at);
        }
        initialHasMatchedNode = state.hasMatchedNode();
        allErrors = new LinkedHashSet<E>();
        grandParentScope = collectorContext.enterDynamicScope();
        try {
            numberOfValidSubSchemas = 0;
            for (JsonSchema schema : this.schemas) {
                block24: {
                    block25: {
                        block22: {
                            block23: {
                                block21: {
                                    block20: {
                                        errors = Collections.emptySet();
                                        parentScope = collectorContext.enterDynamicScope();
                                        try {
                                            state.setMatchedNode(initialHasMatchedNode);
                                            if (!schema.hasTypeValidator() || (typeValidator = schema.getTypeValidator()).getSchemaType() == JsonType.UNION || typeValidator.equalsToSchemaType(node)) break block20;
                                            allErrors.add(this.buildValidationMessage(at, new String[]{typeValidator.getSchemaType().toString()}));
                                            scope = collectorContext.exitDynamicScope();
                                            if (!errors.isEmpty()) continue;
                                            parentScope.mergeWith(scope);
                                        }
                                        catch (Throwable var16_17) {
                                            scope = collectorContext.exitDynamicScope();
                                            if (errors.isEmpty()) {
                                                parentScope.mergeWith(scope);
                                            }
                                            throw var16_17;
                                        }
                                        continue;
                                    }
                                    errors = state.isWalkEnabled() == false ? schema.validate(node, rootNode, at) : schema.walk(node, rootNode, at, true);
                                    if (!errors.isEmpty()) ** GOTO lbl43
                                    if (state.hasMatchedNode()) break block21;
                                    scope = collectorContext.exitDynamicScope();
                                    if (!errors.isEmpty()) continue;
                                    parentScope.mergeWith((CollectorContext.Scope)scope);
                                    continue;
                                }
                                ++numberOfValidSubSchemas;
lbl43:
                                // 2 sources

                                if (!errors.isEmpty() || this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) break block22;
                                allErrors.clear();
                                scope = errors;
                                scope = collectorContext.exitDynamicScope();
                                if (!errors.isEmpty()) break block23;
                                parentScope.mergeWith(scope);
                            }
                            return scope;
                        }
                        if (!this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() || !this.discriminatorContext.isDiscriminatorMatchFound()) break block24;
                        if (!errors.isEmpty()) {
                            allErrors.addAll(errors);
                            allErrors.add(this.buildValidationMessage(at, new String[]{"and the discriminator-selected candidate schema didn't pass validation"}));
                        } else {
                            allErrors.clear();
                        }
                        scope = errors;
                        scope = collectorContext.exitDynamicScope();
                        if (!errors.isEmpty()) break block25;
                        parentScope.mergeWith(scope);
                    }
                    return scope;
                }
                allErrors.addAll(errors);
                scope = collectorContext.exitDynamicScope();
                if (!errors.isEmpty()) continue;
                parentScope.mergeWith((CollectorContext.Scope)scope);
            }
            childNotRequiredErrors = allErrors.stream().filter((Predicate<ValidationMessage>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$validate$0(com.networknt.schema.ValidationMessage ), (Lcom/networknt/schema/ValidationMessage;)Z)()).collect(Collectors.toSet());
            if (numberOfValidSubSchemas >= 1 && childNotRequiredErrors.isEmpty()) {
                allErrors = childNotRequiredErrors;
            }
            if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && this.discriminatorContext.isActive()) {
                errors = new HashSet<ValidationMessage>();
                errors.add(this.buildValidationMessage(at, new String[]{"based on the provided discriminator. No alternative could be chosen based on the discriminator property"}));
                var12_13 = Collections.unmodifiableSet(errors);
                return var12_13;
            }
        }
        finally {
            if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
                this.validationContext.leaveDiscriminatorContextImmediately(at);
            }
            parentScope = collectorContext.exitDynamicScope();
            if (allErrors.isEmpty()) {
                state.setMatchedNode(true);
                grandParentScope.mergeWith(parentScope);
            }
        }
        return Collections.unmodifiableSet(allErrors);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(node, rootNode, at);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(node, rootNode, at, false);
        }
        return new LinkedHashSet<ValidationMessage>();
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
    }

    private static /* synthetic */ boolean lambda$validate$0(ValidationMessage error) {
        return !ValidatorTypeCode.REQUIRED.getValue().equals(error.getType());
    }
}

