/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.recording.ResponseDefinitionBodyMatcher;
import com.github.tomakehurst.wiremock.recording.ScenarioProcessor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingBodyExtractor;
import com.github.tomakehurst.wiremock.recording.SnapshotStubMappingTransformerRunner;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.google.common.collect.HashMultiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SnapshotStubMappingPostProcessor {
    private final boolean shouldRecordRepeatsAsScenarios;
    private final SnapshotStubMappingTransformerRunner transformerRunner;
    private final ResponseDefinitionBodyMatcher bodyExtractMatcher;
    private final SnapshotStubMappingBodyExtractor bodyExtractor;

    public SnapshotStubMappingPostProcessor(boolean shouldRecordRepeatsAsScenarios, SnapshotStubMappingTransformerRunner transformerRunner, ResponseDefinitionBodyMatcher bodyExtractMatcher, SnapshotStubMappingBodyExtractor bodyExtractor) {
        this.shouldRecordRepeatsAsScenarios = shouldRecordRepeatsAsScenarios;
        this.transformerRunner = transformerRunner;
        this.bodyExtractMatcher = bodyExtractMatcher;
        this.bodyExtractor = bodyExtractor;
    }

    public List<StubMapping> process(Collection<StubMapping> stubMappings) {
        List transformedStubMappings = stubMappings.stream().map(this.transformerRunner).collect(Collectors.toList());
        HashMultiset<RequestPattern> requestCounts = HashMultiset.create();
        ArrayList<StubMapping> processedStubMappings = new ArrayList<StubMapping>();
        for (StubMapping transformedStubMapping : transformedStubMappings) {
            requestCounts.add(transformedStubMapping.getRequest());
            if (requestCounts.count(transformedStubMapping.getRequest()) > 1 && !this.shouldRecordRepeatsAsScenarios) continue;
            processedStubMappings.add(transformedStubMapping);
        }
        if (this.shouldRecordRepeatsAsScenarios) {
            new ScenarioProcessor().putRepeatedRequestsInScenarios(processedStubMappings);
        }
        this.extractStubMappingBodies(processedStubMappings);
        return processedStubMappings;
    }

    private void extractStubMappingBodies(List<StubMapping> stubMappings) {
        if (this.bodyExtractMatcher == null) {
            return;
        }
        for (StubMapping stubMapping : stubMappings) {
            if (!this.bodyExtractMatcher.match(stubMapping.getResponse()).isExactMatch()) continue;
            this.bodyExtractor.extractInPlace(stubMapping);
        }
    }
}

