/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.JsonPathPatternJsonSerializer;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.PathPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonSerialize(using=JsonPathPatternJsonSerializer.class)
public class MatchesJsonPathPattern
extends PathPattern {
    public MatchesJsonPathPattern(@JsonProperty(value="matchesJsonPath") String expectedJsonPath, StringValuePattern valuePattern) {
        super(expectedJsonPath, valuePattern);
    }

    public MatchesJsonPathPattern(String value) {
        this(value, null);
    }

    public String getMatchesJsonPath() {
        return (String)this.expectedValue;
    }

    @Override
    protected MatchResult isSimpleMatch(String value) {
        if (value != null && value.trim().startsWith("<")) {
            String message = String.format("Warning: JSON path expression '%s' failed to match document '%s' because it's not JSON but probably XML", this.expectedValue, value);
            LocalNotifier.notifier().info(message);
            return MatchResult.noMatch(SubEvent.warning(message));
        }
        try {
            Object obj = JsonPath.read(value, (String)this.expectedValue, new Predicate[0]);
            boolean result = obj instanceof Collection ? !((Collection)obj).isEmpty() : (obj instanceof Map ? !((Map)obj).isEmpty() : obj != null);
            return MatchResult.of(result, new SubEvent[0]);
        }
        catch (Exception e) {
            Object error = e.getMessage().equalsIgnoreCase("invalid path") ? "the JSON path didn't match the document structure" : (e.getMessage().equalsIgnoreCase("invalid container object") ? "the JSON document couldn't be parsed" : "of error '" + e.getMessage() + "'");
            String message = String.format("Warning: JSON path expression '%s' failed to match document '%s' because %s", this.expectedValue, value, error);
            return MatchResult.noMatch(SubEvent.warning(message));
        }
    }

    @Override
    protected MatchResult isAdvancedMatch(String value) {
        try {
            ListOrSingle<String> expressionResult = this.getExpressionResult(value);
            if ((expressionResult == null || expressionResult.isEmpty()) && AbsentPattern.class.isAssignableFrom(this.valuePattern.getClass())) {
                expressionResult = ListOrSingle.of(new String[]{null});
            }
            List matchResults = expressionResult.stream().map(this.valuePattern::match).collect(Collectors.toList());
            List subEvents = matchResults.stream().map(MatchResult::getSubEvents).flatMap(Collection::stream).collect(Collectors.toList());
            return matchResults.stream().min(Comparator.comparingDouble(MatchResult::getDistance)).orElseGet(() -> MatchResult.noMatch(subEvents));
        }
        catch (PathPattern.SubExpressionException e) {
            return MatchResult.noMatch(SubEvent.warning(e.getMessage()));
        }
    }

    @Override
    public ListOrSingle<String> getExpressionResult(String value) {
        ListOrSingle<String> expressionResult;
        if (value != null && value.trim().startsWith("<")) {
            String message = String.format("Warning: JSON path expression '%s' failed to match document '%s' because it's not JSON but probably XML", this.expectedValue, value);
            throw new PathPattern.SubExpressionException(message);
        }
        Object obj = null;
        try {
            obj = JsonPath.read(value, (String)this.expectedValue, new Predicate[0]);
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (Exception e) {
            Object error = e.getMessage().equalsIgnoreCase("invalid container object") ? "the JSON document couldn't be parsed" : "of error '" + e.getMessage() + "'";
            String message = String.format("Warning: JSON path expression '%s' failed to match document '%s' because %s", this.expectedValue, value, error);
            throw new PathPattern.SubExpressionException(message, e);
        }
        if (obj instanceof Map || obj instanceof List && EqualToJsonPattern.class.isAssignableFrom(this.valuePattern.getClass())) {
            expressionResult = ListOrSingle.of(new String[]{Json.write(obj)});
        } else if (obj instanceof List) {
            List stringValues = ((List)obj).stream().map(Object::toString).collect(Collectors.toList());
            expressionResult = ListOrSingle.of(stringValues);
        } else {
            expressionResult = obj instanceof Number || obj instanceof String || obj instanceof Boolean ? ListOrSingle.of(new String[]{String.valueOf(obj)}) : ListOrSingle.of(new String[0]);
        }
        return expressionResult;
    }
}

