/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class WireMockRule
extends WireMockServer
implements TestRule {
    private final boolean failOnUnmatchedRequests;

    public WireMockRule(Options options) {
        this(options, true);
    }

    public WireMockRule(Options options, boolean failOnUnmatchedRequests) {
        super(options);
        this.failOnUnmatchedRequests = failOnUnmatchedRequests;
    }

    public WireMockRule(int port) {
        this(WireMockConfiguration.wireMockConfig().port(port));
    }

    public WireMockRule(int port, Integer httpsPort) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort));
    }

    public WireMockRule() {
        this(WireMockConfiguration.wireMockConfig());
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                WireMockRule.this.start();
                if (WireMockRule.this.options.getHttpDisabled()) {
                    WireMock.configureFor("https", "localhost", WireMockRule.this.httpsPort());
                } else {
                    WireMock.configureFor("localhost", WireMockRule.this.port());
                }
                try {
                    WireMockRule.this.before();
                    base.evaluate();
                    if (WireMockRule.this.failOnUnmatchedRequests) {
                        WireMockRule.this.checkForUnmatchedRequests();
                    }
                }
                finally {
                    WireMockRule.this.after();
                    WireMockRule.this.stop();
                }
            }
        };
    }

    protected void before() {
    }

    protected void after() {
    }
}

