/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.DefaultNetworkAddressRules;
import com.github.tomakehurst.wiremock.common.NetworkAddressRange;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public interface NetworkAddressRules {
    public static final NetworkAddressRules ALLOW_ALL = new DefaultNetworkAddressRules(Set.of(NetworkAddressRange.ALL), Collections.emptySet());

    public static Builder builder() {
        return new Builder();
    }

    public boolean isAllowed(String var1);

    public static class Builder {
        private final Set<NetworkAddressRange> allowed = new HashSet<NetworkAddressRange>();
        private final Set<NetworkAddressRange> denied = new HashSet<NetworkAddressRange>();

        public Builder allow(String expression) {
            this.allowed.add(NetworkAddressRange.of(expression));
            return this;
        }

        public Builder deny(String expression) {
            this.denied.add(NetworkAddressRange.of(expression));
            return this;
        }

        public NetworkAddressRules build() {
            Set<NetworkAddressRange> allowedRanges = this.allowed;
            if (allowedRanges.isEmpty()) {
                allowedRanges = Set.of(NetworkAddressRange.ALL);
            }
            return new DefaultNetworkAddressRules(Set.copyOf(allowedRanges), Set.copyOf(this.denied));
        }
    }
}

