/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import org.w3c.dom.Node;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.DefaultComparisonFormatter;

public class Comparison {
    private final Detail control;
    private final Detail test;
    private final ComparisonType type;

    public Comparison(ComparisonType t2, Node controlTarget, String controlXPath, Object controlValue, String controlParentXPath, Node testTarget, String testXPath, Object testValue, String testParentXPath) {
        this.type = t2;
        this.control = new Detail(controlTarget, controlXPath, controlValue, controlParentXPath);
        this.test = new Detail(testTarget, testXPath, testValue, testParentXPath);
    }

    public ComparisonType getType() {
        return this.type;
    }

    public Detail getControlDetails() {
        return this.control;
    }

    public Detail getTestDetails() {
        return this.test;
    }

    public String toString(ComparisonFormatter formatter) {
        return formatter.getDescription(this);
    }

    public String toString() {
        return this.toString(new DefaultComparisonFormatter());
    }

    public static class Detail {
        private final Node target;
        private final String xpath;
        private final Object value;
        private final String parentXPath;

        private Detail(Node n, String x, Object v, String parentX) {
            this.target = n;
            this.xpath = x;
            this.value = v;
            this.parentXPath = parentX;
        }

        public Node getTarget() {
            return this.target;
        }

        public String getXPath() {
            return this.xpath;
        }

        public Object getValue() {
            return this.value;
        }

        public String getParentXPath() {
            return this.parentXPath;
        }
    }
}

