/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.matching.EagerMatchResult;
import com.github.tomakehurst.wiremock.matching.WeightedMatchResult;
import com.github.tomakehurst.wiremock.stubbing.SubEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class MatchResult
implements Comparable<MatchResult> {
    private final Queue<SubEvent> subEvents;
    public static final Predicate<WeightedMatchResult> ARE_EXACT_MATCH = WeightedMatchResult::isExactMatch;

    public MatchResult() {
        this.subEvents = new LinkedBlockingQueue<SubEvent>();
    }

    public MatchResult(List<SubEvent> subEvents) {
        this.subEvents = new LinkedBlockingQueue<SubEvent>(subEvents);
    }

    protected void appendSubEvent(SubEvent subEvent) {
        this.subEvents.add(subEvent);
    }

    public List<SubEvent> getSubEvents() {
        return this.subEvents.stream().collect(Collectors.toUnmodifiableList());
    }

    @JsonCreator
    public static MatchResult partialMatch(@JsonProperty(value="distance") double distance) {
        return new EagerMatchResult(distance);
    }

    public static MatchResult exactMatch(SubEvent ... subEvents) {
        return MatchResult.exactMatch(List.of(subEvents));
    }

    public static MatchResult exactMatch(List<SubEvent> subEvents) {
        return new EagerMatchResult(0.0, subEvents);
    }

    public static MatchResult noMatch(SubEvent ... subEvents) {
        return MatchResult.noMatch(List.of(subEvents));
    }

    public static MatchResult noMatch(List<SubEvent> subEvents) {
        return new EagerMatchResult(1.0, subEvents);
    }

    public static MatchResult of(boolean isMatch, SubEvent ... subEvents) {
        return MatchResult.of(isMatch, List.of(subEvents));
    }

    public static MatchResult of(boolean isMatch, List<SubEvent> subEvents) {
        return isMatch ? MatchResult.exactMatch(subEvents) : MatchResult.noMatch(subEvents);
    }

    public static MatchResult aggregate(MatchResult ... matches) {
        return MatchResult.aggregate(Arrays.asList(matches));
    }

    public static MatchResult aggregate(List<MatchResult> matchResults) {
        return MatchResult.aggregateWeighted(matchResults.stream().map(WeightedMatchResult::new).collect(Collectors.toList()));
    }

    public static MatchResult aggregateWeighted(WeightedMatchResult ... matchResults) {
        return MatchResult.aggregateWeighted(Arrays.asList(matchResults));
    }

    public static MatchResult aggregateWeighted(final List<WeightedMatchResult> matchResults) {
        List allSubEvents = matchResults.stream().flatMap(weightedResult -> weightedResult.getMatchResult().getSubEvents().stream()).collect(Collectors.toList());
        return new MatchResult(allSubEvents){

            @Override
            public boolean isExactMatch() {
                return matchResults.stream().allMatch(ARE_EXACT_MATCH);
            }

            @Override
            public double getDistance() {
                double totalDistance = 0.0;
                double sizeWithWeighting = 0.0;
                for (WeightedMatchResult matchResult : matchResults) {
                    totalDistance += matchResult.getDistance();
                    sizeWithWeighting += matchResult.getWeighting();
                }
                return totalDistance / sizeWithWeighting;
            }
        };
    }

    @JsonIgnore
    public abstract boolean isExactMatch();

    public abstract double getDistance();

    @Override
    public int compareTo(MatchResult other) {
        return Double.compare(other.getDistance(), this.getDistance());
    }
}

