/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.internal;

import com.github.tomakehurst.wiremock.store.Store;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.wiremock.extensions.state.internal.Context;
import org.wiremock.extensions.state.internal.ExtensionLogger;

public class ContextManager {
    private final Store<String, Object> store;

    public ContextManager(Store<String, Object> store) {
        this.store = store;
    }

    private static Supplier<Context> createNewContext(String contextName) {
        ExtensionLogger.logger().info(contextName, "created");
        return () -> new Context(contextName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getState(String contextName, String property) {
        Store<String, Object> store = this.store;
        synchronized (store) {
            return this.store.get(contextName).map(it -> ((Context)it).getProperties().get(property)).orElse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Context> getContext(String contextName) {
        Store<String, Object> store = this.store;
        synchronized (store) {
            return this.store.get(contextName).map(it -> (Context)it).map(Context::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteContext(String contextName) {
        Store<String, Object> store = this.store;
        synchronized (store) {
            this.store.remove(contextName);
            ExtensionLogger.logger().info(contextName, "deleted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllContexts() {
        Store<String, Object> store = this.store;
        synchronized (store) {
            ExtensionLogger.logger().info("allContexts", "deleted");
            this.store.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long createOrUpdateContextState(String contextName, Map<String, String> properties) {
        Store<String, Object> store = this.store;
        synchronized (store) {
            Context context = this.store.get(contextName).map(it -> (Context)it).map(it -> {
                it.incUpdateCount();
                return it;
            }).orElseGet(ContextManager.createNewContext(contextName));
            properties.forEach((k, v) -> {
                if (v.equals("null")) {
                    context.getProperties().remove(k);
                    ExtensionLogger.logger().info(contextName, String.format("property '%s' removed", k));
                } else {
                    context.getProperties().put((String)k, (String)v);
                    ExtensionLogger.logger().info(contextName, String.format("property '%s' updated", k));
                }
            });
            this.store.put(contextName, context);
            return context.getUpdateCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long createOrUpdateContextList(String contextName, Consumer<LinkedList<Map<String, String>>> consumer) {
        Store<String, Object> store = this.store;
        synchronized (store) {
            Context context = this.store.get(contextName).map(it -> (Context)it).map(it -> {
                it.incUpdateCount();
                return it;
            }).orElseGet(ContextManager.createNewContext(contextName));
            consumer.accept(context.getList());
            this.store.put(contextName, context);
            return context.getUpdateCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long numUpdates(String contextName) {
        Store<String, Object> store = this.store;
        synchronized (store) {
            return this.store.get(contextName).map(it -> ((Context)it).getUpdateCount()).orElse(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long numReads(String contextName) {
        Store<String, Object> store = this.store;
        synchronized (store) {
            return this.store.get(contextName).map(it -> ((Context)it).getMatchCount()).orElse(0L);
        }
    }
}

