/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extensions.state.extensions;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.core.ConfigurationException;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.extension.ServeEventListener;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestTemplateModel;
import com.github.tomakehurst.wiremock.extension.responsetemplating.TemplateEngine;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.wiremock.extensions.state.internal.ContextManager;
import org.wiremock.extensions.state.internal.DeleteStateParameters;
import org.wiremock.extensions.state.internal.ExtensionLogger;
import org.wiremock.extensions.state.internal.ResponseTemplateModel;
import org.wiremock.extensions.state.internal.StateExtensionMixin;

public class DeleteStateEventListener
implements ServeEventListener,
StateExtensionMixin {
    private final TemplateEngine templateEngine;
    private final ContextManager contextManager;

    public DeleteStateEventListener(ContextManager contextManager, TemplateEngine templateEngine) {
        this.contextManager = contextManager;
        this.templateEngine = templateEngine;
    }

    @Override
    public String getName() {
        return "deleteState";
    }

    @Override
    public boolean applyGlobally() {
        return false;
    }

    @Override
    public void beforeResponseSent(ServeEvent serveEvent, Parameters parameters) {
        Map<String, Object> model = Map.of("request", RequestTemplateModel.from(serveEvent.getRequest()), "response", ResponseTemplateModel.from(serveEvent.getResponse()));
        DeleteStateParameters configuration = Json.mapToObject(parameters, DeleteStateParameters.class);
        String contextName = this.createContextName(model, configuration);
        Optional.ofNullable(configuration.getList()).ifPresentOrElse(listConfig -> this.handleListDeletion((DeleteStateParameters.ListParameters)listConfig, contextName, model), () -> this.contextManager.deleteContext(contextName));
    }

    private void handleListDeletion(DeleteStateParameters.ListParameters listConfig, String contextName, Map<String, Object> model) {
        if (Boolean.TRUE.equals(listConfig.getDeleteFirst())) {
            this.deleteFirst(contextName);
        } else if (Boolean.TRUE.equals(listConfig.getDeleteLast())) {
            this.deleteLast(contextName);
        } else if (StringUtils.isNotBlank(listConfig.getDeleteIndex())) {
            this.deleteIndex(listConfig, contextName, model);
        } else if (listConfig.getDeleteWhere() != null && listConfig.getDeleteWhere().getProperty() != null && listConfig.getDeleteWhere().getValue() != null) {
            this.deleteWhere(listConfig, contextName, model);
        } else {
            throw this.createConfigurationError("Missing/invalid configuration for list: ", new String[0]);
        }
    }

    private Long deleteFirst(String contextName) {
        return this.contextManager.createOrUpdateContextList(contextName, maps -> {
            if (!maps.isEmpty()) {
                maps.removeFirst();
            }
            ExtensionLogger.logger().info(contextName, "list::deleteFirst");
        });
    }

    private void deleteLast(String contextName) {
        this.contextManager.createOrUpdateContextList(contextName, maps -> {
            if (!maps.isEmpty()) {
                maps.removeLast();
            }
            ExtensionLogger.logger().info(contextName, "list::deleteLast");
        });
    }

    private void deleteIndex(DeleteStateParameters.ListParameters listConfig, String contextName, Map<String, Object> model) {
        try {
            int index = Integer.parseInt(this.renderTemplate(model, listConfig.getDeleteIndex()));
            this.contextManager.createOrUpdateContextList(contextName, list -> {
                list.remove(index);
                ExtensionLogger.logger().info(contextName, String.format("list::deleteIndex(%d)", index));
            });
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw this.createConfigurationError("List index '%s' does not exist or cannot be parsed: %s", listConfig.getDeleteIndex(), e.getMessage());
        }
    }

    private void deleteWhere(DeleteStateParameters.ListParameters listConfig, String contextName, Map<String, Object> model) {
        String property = this.renderTemplate(model, listConfig.getDeleteWhere().getProperty());
        String value = this.renderTemplate(model, listConfig.getDeleteWhere().getValue());
        this.contextManager.createOrUpdateContextList(contextName, list -> {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Map element = (Map)iterator.next();
                if (!Objects.equals(element.getOrDefault(property, null), value)) continue;
                iterator.remove();
                ExtensionLogger.logger().info(contextName, String.format("list::deleteWhere(property=%s)", property));
                break;
            }
        });
    }

    private String createContextName(Map<String, Object> model, DeleteStateParameters parameters) {
        String rawContext = Optional.ofNullable(parameters.getContext()).filter(StringUtils::isNotBlank).orElseThrow(() -> new ConfigurationException("no context specified"));
        String context = this.renderTemplate(model, rawContext);
        if (StringUtils.isBlank(context)) {
            throw this.createConfigurationError("Context cannot be blank", new String[0]);
        }
        return context;
    }

    private String renderTemplate(Object context, String value) {
        return this.templateEngine.getUncachedTemplate(value).apply(context);
    }
}

