/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.transform.Source;
import org.custommonkey.xmlunit.ComparisonController;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceConstants;
import org.custommonkey.xmlunit.DifferenceEngineContract;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.ElementNameAndTextQualifier;
import org.custommonkey.xmlunit.ElementNameQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.MatchTracker;
import org.custommonkey.xmlunit.NodeDetail;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.examples.RecursiveElementNameAndTextQualifier;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ByNameAndTextRecSelector;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.DOMDifferenceEngine;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.NodeFilters;
import org.xmlunit.diff.NodeMatcher;
import org.xmlunit.input.CommentLessSource;
import org.xmlunit.input.WhitespaceNormalizedSource;
import org.xmlunit.input.WhitespaceStrippedSource;
import org.xmlunit.util.IterableNodeList;
import org.xmlunit.util.Linqy;
import org.xmlunit.util.Predicate;

public class NewDifferenceEngine
implements DifferenceConstants,
DifferenceEngineContract {
    private static final Integer ZERO = 0;
    private static final Map<Class<? extends ElementQualifier>, ElementSelector> KNOWN_SELECTORS;
    private final ComparisonController controller;
    private MatchTracker matchTracker;

    public NewDifferenceEngine(ComparisonController controller) {
        this(controller, null);
    }

    public NewDifferenceEngine(ComparisonController controller, MatchTracker matchTracker) {
        this.controller = controller;
        this.matchTracker = matchTracker;
    }

    @Override
    public void setMatchTracker(MatchTracker matchTracker) {
        this.matchTracker = matchTracker;
    }

    @Override
    public void compare(Node control, Node test, DifferenceListener listener, ElementQualifier elementQualifier) {
        DOMDifferenceEngine engine = new DOMDifferenceEngine();
        engine.setNodeFilter(NodeFilters.AcceptAll);
        IsBetweenDocumentNodeAndRootElement checkPrelude = new IsBetweenDocumentNodeAndRootElement();
        engine.addComparisonListener(checkPrelude);
        if (this.matchTracker != null) {
            engine.addMatchListener(new MatchTracker2ComparisonListener(this.matchTracker));
        }
        ComparisonController2ComparisonController mappedController = new ComparisonController2ComparisonController(this.controller);
        engine.setComparisonController(mappedController);
        if (listener != null) {
            DifferenceEvaluator evaluator = DifferenceEvaluators.chain(DifferenceEvaluators.Default, DifferenceEvaluators.ignorePrologDifferencesExceptDoctype(), new IgnoreDoctypeNotPresentDifferences(), new DifferenceListener2DifferenceEvaluator(listener));
            engine.setDifferenceEvaluator(evaluator);
        }
        DefaultNodeMatcher m4 = new DefaultNodeMatcher();
        if (elementQualifier != null) {
            Class<?> c = elementQualifier.getClass();
            m4 = KNOWN_SELECTORS.containsKey(c) ? new DefaultNodeMatcher(KNOWN_SELECTORS.get(c)) : new DefaultNodeMatcher(new ElementQualifier2ElementSelector(elementQualifier));
        }
        if (!XMLUnit.getCompareUnmatched()) {
            engine.setNodeMatcher(m4);
        } else {
            engine.setNodeMatcher(new CompareUnmatchedNodeMatcher(m4));
        }
        Input.Builder ctrlBuilder = Input.fromNode(control);
        Input.Builder tstBuilder = Input.fromNode(test);
        Source ctrlSource = ctrlBuilder.build();
        Source tstSource = tstBuilder.build();
        if (XMLUnit.getIgnoreComments()) {
            ctrlSource = new CommentLessSource(ctrlSource);
            tstSource = new CommentLessSource(tstSource);
        }
        if (XMLUnit.getNormalizeWhitespace()) {
            ctrlSource = new WhitespaceNormalizedSource(ctrlSource);
            tstSource = new WhitespaceNormalizedSource(tstSource);
        } else if (XMLUnit.getIgnoreWhitespace()) {
            ctrlSource = new WhitespaceStrippedSource(ctrlSource);
            tstSource = new WhitespaceStrippedSource(tstSource);
        }
        engine.compare(ctrlSource, tstSource);
    }

    private static Iterable<Difference> toDifference(org.xmlunit.diff.Difference d) {
        return NewDifferenceEngine.toDifference(d.getComparison());
    }

    public static Iterable<Difference> toDifference(Comparison comp) {
        LinkedList<Difference> diffs = new LinkedList<Difference>();
        Difference proto = null;
        switch (comp.getType()) {
            case ATTR_VALUE_EXPLICITLY_SPECIFIED: {
                proto = ATTR_VALUE_EXPLICITLY_SPECIFIED;
                break;
            }
            case HAS_DOCTYPE_DECLARATION: {
                proto = HAS_DOCTYPE_DECLARATION;
                break;
            }
            case DOCTYPE_NAME: {
                proto = DOCTYPE_NAME;
                break;
            }
            case DOCTYPE_PUBLIC_ID: {
                proto = DOCTYPE_PUBLIC_ID;
                break;
            }
            case DOCTYPE_SYSTEM_ID: {
                proto = DOCTYPE_SYSTEM_ID;
                break;
            }
            case SCHEMA_LOCATION: {
                proto = SCHEMA_LOCATION;
                break;
            }
            case NO_NAMESPACE_SCHEMA_LOCATION: {
                proto = NO_NAMESPACE_SCHEMA_LOCATION;
                break;
            }
            case NODE_TYPE: {
                proto = NODE_TYPE;
                break;
            }
            case NAMESPACE_PREFIX: {
                proto = NAMESPACE_PREFIX;
                break;
            }
            case NAMESPACE_URI: {
                proto = NAMESPACE_URI;
                break;
            }
            case TEXT_VALUE: {
                if (comp.getControlDetails().getTarget() instanceof CDATASection) {
                    proto = CDATA_VALUE;
                    break;
                }
                if (comp.getControlDetails().getTarget() instanceof Comment) {
                    proto = COMMENT_VALUE;
                    break;
                }
                proto = TEXT_VALUE;
                break;
            }
            case PROCESSING_INSTRUCTION_TARGET: {
                proto = PROCESSING_INSTRUCTION_TARGET;
                break;
            }
            case PROCESSING_INSTRUCTION_DATA: {
                proto = PROCESSING_INSTRUCTION_DATA;
                break;
            }
            case ELEMENT_TAG_NAME: {
                proto = ELEMENT_TAG_NAME;
                break;
            }
            case ELEMENT_NUM_ATTRIBUTES: {
                proto = ELEMENT_NUM_ATTRIBUTES;
                break;
            }
            case ATTR_VALUE: {
                proto = ATTR_VALUE;
                break;
            }
            case CHILD_NODELIST_LENGTH: {
                Comparison.Detail cd2 = comp.getControlDetails();
                Comparison.Detail td = comp.getTestDetails();
                if (ZERO.equals(cd2.getValue()) || ZERO.equals(td.getValue())) {
                    diffs.add(new Difference(HAS_CHILD_NODES, new NodeDetail(String.valueOf(!ZERO.equals(cd2.getValue())), cd2.getTarget(), cd2.getXPath()), new NodeDetail(String.valueOf(!ZERO.equals(td.getValue())), td.getTarget(), td.getXPath())));
                }
                proto = CHILD_NODELIST_LENGTH;
                break;
            }
            case CHILD_NODELIST_SEQUENCE: {
                proto = CHILD_NODELIST_SEQUENCE;
                break;
            }
            case CHILD_LOOKUP: {
                proto = CHILD_NODE_NOT_FOUND;
                break;
            }
            case ATTR_NAME_LOOKUP: {
                proto = ATTR_NAME_NOT_FOUND;
                break;
            }
        }
        if (proto != null) {
            diffs.add(new Difference(proto, NewDifferenceEngine.toNodeDetail(comp.getControlDetails()), NewDifferenceEngine.toNodeDetail(comp.getTestDetails())));
        }
        return diffs;
    }

    public static NodeDetail toNodeDetail(Comparison.Detail detail) {
        String value = String.valueOf(detail.getValue());
        if (detail.getValue() instanceof Node) {
            value = ((Node)detail.getValue()).getNodeName();
        }
        return new NodeDetail(value, detail.getTarget(), detail.getXPath());
    }

    static {
        HashMap<Class<RecursiveElementNameAndTextQualifier>, ElementSelector> m4 = new HashMap<Class<RecursiveElementNameAndTextQualifier>, ElementSelector>();
        m4.put(ElementNameAndTextQualifier.class, ElementSelectors.byNameAndText);
        m4.put(ElementNameQualifier.class, ElementSelectors.byName);
        m4.put(RecursiveElementNameAndTextQualifier.class, new ByNameAndTextRecSelector());
        KNOWN_SELECTORS = Collections.unmodifiableMap(m4);
    }

    private static class IsBetweenDocumentNodeAndRootElement
    implements ComparisonListener {
        private boolean haveSeenXmlEncoding = false;
        private boolean haveSeenElementNodeComparison = false;

        private IsBetweenDocumentNodeAndRootElement() {
        }

        @Override
        public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
            if (comparison.getType() == ComparisonType.XML_ENCODING) {
                this.haveSeenXmlEncoding = true;
            } else if (comparison.getControlDetails().getTarget() instanceof Element && (comparison.getType() == ComparisonType.NODE_TYPE || comparison.getType() == ComparisonType.CHILD_LOOKUP)) {
                this.haveSeenElementNodeComparison = true;
            }
        }

        private boolean shouldSkip() {
            return this.haveSeenXmlEncoding && !this.haveSeenElementNodeComparison;
        }
    }

    public static class MatchTracker2ComparisonListener
    implements ComparisonListener {
        private final MatchTracker mt;

        public MatchTracker2ComparisonListener(MatchTracker m4) {
            this.mt = m4;
        }

        @Override
        public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
            for (Difference diff : NewDifferenceEngine.toDifference(comparison)) {
                this.mt.matchFound(diff);
            }
        }
    }

    public static class ComparisonController2ComparisonController
    implements org.xmlunit.diff.ComparisonController {
        private final ComparisonController cc;

        public ComparisonController2ComparisonController(ComparisonController c) {
            this.cc = c;
        }

        @Override
        public boolean stopDiffing(org.xmlunit.diff.Difference difference) {
            for (Difference diff : NewDifferenceEngine.toDifference(difference)) {
                if (!this.cc.haltComparison(diff)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class IgnoreDoctypeNotPresentDifferences
    implements DifferenceEvaluator {
        private IgnoreDoctypeNotPresentDifferences() {
        }

        @Override
        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            if (outcome == ComparisonResult.EQUAL) {
                return outcome;
            }
            if (comparison.getType() == ComparisonType.CHILD_LOOKUP && (this.isDoctype(comparison.getControlDetails()) || this.isDoctype(comparison.getTestDetails()))) {
                return ComparisonResult.EQUAL;
            }
            if (comparison.getType() == ComparisonType.CHILD_NODELIST_LENGTH && this.isDocumentWithDocTypeDifference(comparison) && Math.abs((Integer)comparison.getControlDetails().getValue() - (Integer)comparison.getTestDetails().getValue()) == 1) {
                return ComparisonResult.EQUAL;
            }
            if (comparison.getType() == ComparisonType.CHILD_NODELIST_SEQUENCE && this.isDocumentWithDocTypeDifference(comparison)) {
                return ComparisonResult.EQUAL;
            }
            return outcome;
        }

        private boolean isDoctype(Comparison.Detail detail) {
            return detail != null && detail.getTarget() instanceof DocumentType;
        }

        private boolean isDocumentWithDocTypeDifference(Comparison comparison) {
            if (!(comparison.getControlDetails().getTarget() instanceof Document)) {
                return false;
            }
            return this.hasDoctypeChild(comparison.getControlDetails().getTarget()) || this.hasDoctypeChild(comparison.getTestDetails().getTarget());
        }

        private boolean hasDoctypeChild(Node n) {
            return Linqy.any(new IterableNodeList(n.getChildNodes()), new Predicate<Node>(){

                @Override
                public boolean test(Node n) {
                    return n instanceof DocumentType;
                }
            });
        }
    }

    public static class DifferenceListener2DifferenceEvaluator
    implements DifferenceEvaluator {
        private final DifferenceListener dl;

        public DifferenceListener2DifferenceEvaluator(DifferenceListener dl) {
            this.dl = dl;
        }

        @Override
        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            if (outcome == ComparisonResult.EQUAL) {
                return outcome;
            }
            ComparisonResult max = outcome;
            for (Difference diff : NewDifferenceEngine.toDifference(comparison)) {
                ComparisonResult curr = null;
                switch (this.dl.differenceFound(diff)) {
                    case 1: {
                        curr = ComparisonResult.EQUAL;
                        break;
                    }
                    case 2: {
                        curr = ComparisonResult.SIMILAR;
                        break;
                    }
                    case 3: {
                        curr = ComparisonResult.DIFFERENT;
                        break;
                    }
                }
                if (curr == null || curr.compareTo(max) <= 0) continue;
                max = curr;
            }
            return max;
        }
    }

    public static class ElementQualifier2ElementSelector
    implements ElementSelector {
        private final ElementQualifier eq;

        public ElementQualifier2ElementSelector(ElementQualifier eq) {
            this.eq = eq;
        }

        @Override
        public boolean canBeCompared(Element controlElement, Element testElement) {
            return this.eq.qualifyForComparison(controlElement, testElement);
        }
    }

    private static class CompareUnmatchedNodeMatcher
    implements NodeMatcher {
        private final NodeMatcher nestedMatcher;

        private CompareUnmatchedNodeMatcher(NodeMatcher nested) {
            this.nestedMatcher = nested;
        }

        @Override
        public Iterable<Map.Entry<Node, Node>> match(Iterable<Node> controlNodes, Iterable<Node> testNodes) {
            final HashMap<Node, Node> map = new HashMap<Node, Node>();
            for (Map.Entry<Node, Node> e : this.nestedMatcher.match(controlNodes, testNodes)) {
                map.put(e.getKey(), e.getValue());
            }
            LinkedList<Map.Entry<Node, Node>> result = new LinkedList<Map.Entry<Node, Node>>();
            for (Node n : controlNodes) {
                if (map.containsKey(n)) {
                    result.add(new Entry(n, (Node)map.get(n)));
                    continue;
                }
                Iterable<Node> unmatchedTestElements = Linqy.filter(testNodes, new Predicate<Node>(){

                    @Override
                    public boolean test(Node t2) {
                        return !map.containsValue(t2);
                    }
                });
                Iterator<Node> it = unmatchedTestElements.iterator();
                if (!it.hasNext()) continue;
                Node t2 = it.next();
                map.put(n, t2);
                result.add(new Entry(n, t2));
            }
            return result;
        }

        private static class Entry
        implements Map.Entry<Node, Node> {
            private final Node key;
            private final Node value;

            private Entry(Node k, Node v) {
                this.key = k;
                this.value = v;
            }

            @Override
            public Node getKey() {
                return this.key;
            }

            @Override
            public Node getValue() {
                return this.value;
            }

            @Override
            public Node setValue(Node v) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

