/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension;

import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ExtensionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExtensionDeclarations {
    private final List<String> classNames = new ArrayList<String>();
    private final List<Class<? extends Extension>> classes = new ArrayList<Class<? extends Extension>>();
    private final Map<String, Extension> instances = new LinkedHashMap<String, Extension>();
    private final List<ExtensionFactory> factories = new ArrayList<ExtensionFactory>();

    public void add(String ... classNames) {
        this.classNames.addAll(Arrays.asList(classNames));
    }

    public void add(Extension ... extensionInstances) {
        Arrays.stream(extensionInstances).forEach(e -> this.instances.put(e.getName(), (Extension)e));
    }

    public void add(Class<? extends Extension> ... classes) {
        this.classes.addAll(Arrays.asList(classes));
    }

    public void add(ExtensionFactory ... factories) {
        this.factories.addAll(Arrays.asList(factories));
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public List<Class<? extends Extension>> getClasses() {
        return this.classes;
    }

    public Map<String, Extension> getInstances() {
        return this.instances;
    }

    public List<ExtensionFactory> getFactories() {
        return this.factories;
    }
}

