/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.CachedSupplier;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.InvalidSchemaRefException;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonSchemaRef;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.RefValidator;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class DynamicRefValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DynamicRefValidator.class);
    protected final JsonSchemaRef schema;

    public DynamicRefValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.DYNAMIC_REF, validationContext);
        String refValue = schemaNode.asText();
        this.schema = DynamicRefValidator.getRefSchema(parentSchema, validationContext, refValue, evaluationPath);
    }

    static JsonSchemaRef getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue, JsonNodePath evaluationPath) {
        String ref = DynamicRefValidator.resolve(parentSchema, refValue);
        return new JsonSchemaRef(DynamicRefValidator.getSupplier(() -> {
            JsonSchema refSchema = (JsonSchema)validationContext.getDynamicAnchors().get(ref);
            if (refSchema == null) {
                JsonSchemaRef r = RefValidator.getRefSchema(parentSchema, validationContext, refValue, evaluationPath);
                if (r != null) {
                    refSchema = r.getSchema();
                }
            } else {
                JsonSchema base = parentSchema;
                int index = ref.indexOf("#");
                String anchor = ref.substring(index);
                String absoluteIri = ref.substring(0, index);
                while (base.getEvaluationParentSchema() != null) {
                    String baseAbsoluteIri = (base = base.getEvaluationParentSchema()).getSchemaLocation().getAbsoluteIri() != null ? base.getSchemaLocation().getAbsoluteIri().toString() : "";
                    if (baseAbsoluteIri.equals(absoluteIri)) continue;
                    absoluteIri = baseAbsoluteIri;
                    String parentRef = SchemaLocation.resolve(base.getSchemaLocation(), anchor);
                    JsonSchema parentRefSchema = (JsonSchema)validationContext.getDynamicAnchors().get(parentRef);
                    if (parentRefSchema == null) continue;
                    refSchema = parentRefSchema;
                }
            }
            if (refSchema != null) {
                refSchema = refSchema.fromRef(parentSchema, evaluationPath);
            }
            return refSchema;
        }, validationContext.getConfig().isCacheRefs()));
    }

    static <T> Supplier<T> getSupplier(Supplier<T> supplier, boolean cache) {
        return cache ? new CachedSupplier(supplier) : supplier;
    }

    private static String resolve(JsonSchema parentSchema, String refValue) {
        JsonSchema base = parentSchema;
        if (parentSchema.getId() != null && parentSchema.parentSchema != null) {
            base = parentSchema.parentSchema;
        }
        return SchemaLocation.resolve(base.getSchemaLocation(), refValue);
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        DynamicRefValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        JsonSchema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            ValidationMessage validationMessage = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().type(ValidatorTypeCode.DYNAMIC_REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(validationMessage);
        }
        return refSchema.validate(executionContext, node, rootNode, instanceLocation);
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        DynamicRefValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        JsonSchema refSchema = this.schema.getSchema();
        if (refSchema == null) {
            ValidationMessage validationMessage = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().type(ValidatorTypeCode.DYNAMIC_REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(instanceLocation)).evaluationPath(this.getEvaluationPath())).arguments(this.schemaNode.asText())).build();
            throw new InvalidSchemaRefException(validationMessage);
        }
        if (node == null) {
            SchemaLocation schemaLocation = refSchema.getSchemaLocation();
            JsonSchema check2 = refSchema;
            boolean circularDependency = false;
            while (check2.getEvaluationParentSchema() != null) {
                if (!(check2 = check2.getEvaluationParentSchema()).getSchemaLocation().equals(schemaLocation)) continue;
                circularDependency = true;
                break;
            }
            if (circularDependency) {
                return Collections.emptySet();
            }
        }
        return refSchema.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
    }

    public JsonSchemaRef getSchemaRef() {
        return this.schema;
    }

    @Override
    public void preloadJsonSchema() {
        JsonSchema jsonSchema = null;
        try {
            jsonSchema = this.schema.getSchema();
        }
        catch (JsonSchemaException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new JsonSchemaException(e);
        }
        SchemaLocation schemaLocation = jsonSchema.getSchemaLocation();
        JsonSchema check2 = jsonSchema;
        boolean circularDependency = false;
        int depth = 0;
        while (check2.getEvaluationParentSchema() != null) {
            ++depth;
            if (!(check2 = check2.getEvaluationParentSchema()).getSchemaLocation().equals(schemaLocation)) continue;
            circularDependency = true;
            break;
        }
        if (this.validationContext.getConfig().isCacheRefs() && !circularDependency && depth < this.validationContext.getConfig().getPreloadJsonSchemaRefMaxNestingDepth()) {
            jsonSchema.initializeValidators();
        }
    }
}

