/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.extension.jwt;

import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import java.util.LinkedHashMap;
import wiremock.com.google.common.collect.ImmutableMap;

public class SettingsUtils {
    public static Parameters merge(Parameters ... allParameters) {
        LinkedHashMap<String, Object> builder = new LinkedHashMap<String, Object>();
        for (Parameters params : allParameters) {
            if (params == null) continue;
            builder.putAll(params);
        }
        return Parameters.from(ImmutableMap.copyOf(builder));
    }

    public static GlobalSettings merge(GlobalSettings one, GlobalSettings two) {
        return new GlobalSettings(SettingsUtils.lastOrNull(one.getFixedDelay(), two.getFixedDelay()), SettingsUtils.lastOrNull(one.getDelayDistribution(), two.getDelayDistribution()), SettingsUtils.merge(one.getExtended(), two.getExtended()), two.getProxyPassThrough());
    }

    private static <T> T lastOrNull(T ... values2) {
        for (int i = values2.length - 1; i >= 0; --i) {
            if (values2[i] == null) continue;
            return values2[i];
        }
        return null;
    }
}

