/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Message;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;

public class SubEvent {
    public static final String NON_MATCH_TYPE = "REQUEST_NOT_MATCHED";
    public static final String JSON_ERROR = "JSON_ERROR";
    public static final String XML_ERROR = "XML";
    public static final String INFO = "INFO";
    public static final String WARNING = "WARNING";
    public static final String ERROR = "ERROR";
    private static final List<String> STANDARD_TYPES = Arrays.asList("REQUEST_NOT_MATCHED", "JSON_ERROR", "XML", "INFO", "WARNING", "ERROR");
    private final String type;
    private final Long timeOffsetNanos;
    private final Map<String, Object> data;

    public static SubEvent info(String message) {
        return SubEvent.message(INFO, message);
    }

    public static SubEvent warning(String message) {
        return SubEvent.message(WARNING, message);
    }

    public static SubEvent error(String message) {
        return SubEvent.message(ERROR, message);
    }

    public static SubEvent message(String type, String message) {
        return new SubEvent(type, null, new Message(message));
    }

    public SubEvent(String type, Object data) {
        this(type, null, data);
    }

    public SubEvent(String type, Long timeOffsetMillis, Object data) {
        this(type, timeOffsetMillis, Json.objectToMap(data));
    }

    public SubEvent(@JsonProperty(value="type") String type, @JsonProperty(value="timeOffsetNanos") Long timeOffsetNanos, @JsonProperty(value="data") Map<String, Object> data) {
        this.type = type;
        this.timeOffsetNanos = timeOffsetNanos;
        this.data = data;
    }

    public String getType() {
        return this.type;
    }

    public Long getTimeOffsetNanos() {
        return this.timeOffsetNanos;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public <T> T getDataAs(Class<T> dataType) {
        return Json.mapToObject(this.data, dataType);
    }

    public boolean isEquivalentStandardTypedEventTo(SubEvent other) {
        return this.isStandardType() && other.isStandardType() && this.type.equals(other.type) && this.data.equals(other.data);
    }

    boolean isStandardType() {
        return STANDARD_TYPES.contains(this.type);
    }
}

