/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.multipart;

import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import wiremock.org.apache.commons.fileupload.FileItem;
import wiremock.org.apache.commons.fileupload.FileItemHeaders;

public class FileItemPartAdapter
implements Request.Part {
    private final FileItem fileItem;
    public static final Function<FileItem, Request.Part> TO_PARTS = FileItemPartAdapter::new;

    public FileItemPartAdapter(FileItem fileItem) {
        this.fileItem = fileItem;
    }

    @Override
    public String getName() {
        return this.fileItem.getFieldName();
    }

    @Override
    public HttpHeader getHeader(String name) {
        Iterator<String> headerValues = this.fileItem.getHeaders().getHeaders(name);
        ArrayList<String> values2 = new ArrayList<String>();
        headerValues.forEachRemaining(values2::add);
        return new HttpHeader(name, (Collection<String>)values2);
    }

    @Override
    public HttpHeaders getHeaders() {
        FileItemHeaders headers = this.fileItem.getHeaders();
        Iterator<String> i = headers.getHeaderNames();
        ArrayList<HttpHeader> headersList = new ArrayList<HttpHeader>();
        while (i.hasNext()) {
            String name = i.next();
            headersList.add(this.getHeader(name));
        }
        return new HttpHeaders(Collections.unmodifiableList(headersList));
    }

    @Override
    public Body getBody() {
        return Body.ofBinaryOrText(this.fileItem.get(), new ContentTypeHeader(this.fileItem.getContentType()));
    }
}

