/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import java.util.Objects;

public class HttpTemplateCacheKey {
    private final ResponseDefinition responseDefinition;
    private final ResponseElement element;
    private final String name;
    private final Integer index;

    public static HttpTemplateCacheKey forInlineBody(ResponseDefinition responseDefinition) {
        return new HttpTemplateCacheKey(responseDefinition, ResponseElement.BODY, "[inlineBody]", null);
    }

    public static HttpTemplateCacheKey forFileBody(ResponseDefinition responseDefinition, String filename) {
        return new HttpTemplateCacheKey(responseDefinition, ResponseElement.BODY, filename, null);
    }

    public static HttpTemplateCacheKey forHeader(ResponseDefinition responseDefinition, String headerName, int valueIndex) {
        return new HttpTemplateCacheKey(responseDefinition, ResponseElement.HEADER, headerName, valueIndex);
    }

    public static HttpTemplateCacheKey forProxyUrl(ResponseDefinition responseDefinition) {
        return new HttpTemplateCacheKey(responseDefinition, ResponseElement.PROXY_URL, "[proxyUrl]", null);
    }

    private HttpTemplateCacheKey(ResponseDefinition responseDefinition, ResponseElement element, String name, Integer index) {
        this.responseDefinition = responseDefinition;
        this.element = element;
        this.name = name;
        this.index = index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpTemplateCacheKey that = (HttpTemplateCacheKey)o;
        return this.responseDefinition.equals(that.responseDefinition) && this.element == that.element && this.name.equals(that.name) && Objects.equals(this.index, that.index);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.responseDefinition, this.element, this.name, this.index});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TemplateCacheKey{");
        sb.append("responseDefinition=").append(this.responseDefinition);
        sb.append(", element=").append((Object)this.element);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", index=").append(this.index);
        sb.append('}');
        return sb.toString();
    }

    public static enum ResponseElement {
        BODY,
        PROXY_URL,
        HEADER;

    }
}

