/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.xml;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.xml.XmlNode;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.XMLReader;

public class XmlDomNode
extends XmlNode {
    private final Node domNode;
    private final Map<String, String> attributes;
    private static final Class<XMLReader> DOM2SAX_XMLREADER_CLASS = XmlDomNode.getDom2SaxAvailability();

    public XmlDomNode(Node domNode) {
        this.domNode = domNode;
        this.attributes = domNode.hasAttributes() ? XmlDomNode.convertAttributeMap(domNode.getAttributes()) : Collections.emptyMap();
    }

    private static Map<String, String> convertAttributeMap(NamedNodeMap namedNodeMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            map.put(node.getNodeName(), node.getNodeValue());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.domNode.getNodeName();
    }

    public String getText() {
        return this.domNode.getTextContent();
    }

    public String toString() {
        switch (this.domNode.getNodeType()) {
            case 2: 
            case 3: {
                return this.domNode.getTextContent();
            }
            case 1: 
            case 9: {
                return this.render();
            }
        }
        return this.domNode.toString();
    }

    private String render() {
        try {
            Transformer transformer = (Transformer)TRANSFORMER_CACHE.get();
            StreamResult result = new StreamResult(new StringWriter());
            Source source2 = XmlDomNode.getSourceForTransform(this.domNode);
            transformer.transform(source2, result);
            return result.getWriter().toString();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, String.class);
        }
    }

    private static Class<XMLReader> getDom2SaxAvailability() {
        try {
            return Class.forName("com.sun.org.apache.xalan.internal.xsltc.trax.DOM2SAX");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Source getSourceForTransform(Node node) {
        if (DOM2SAX_XMLREADER_CLASS != null) {
            try {
                Constructor<XMLReader> constructor = DOM2SAX_XMLREADER_CLASS.getConstructor(Node.class);
                XMLReader dom2SAX = constructor.newInstance(node);
                SAXSource saxSource = new SAXSource();
                saxSource.setXMLReader(dom2SAX);
                return saxSource;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return new DOMSource(node);
            }
        }
        return new DOMSource(node);
    }
}

