/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ChunkedDribbleDelay;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.LogNormal;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.UniformDistribution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import wiremock.com.fasterxml.jackson.databind.JsonNode;

public class ResponseDefinitionBuilder {
    protected int status = 200;
    protected String statusMessage;
    protected Body body = Body.none();
    protected String bodyFileName;
    protected List<HttpHeader> headers = new ArrayList<HttpHeader>();
    protected Integer fixedDelayMilliseconds;
    protected DelayDistribution delayDistribution;
    protected ChunkedDribbleDelay chunkedDribbleDelay;
    protected String proxyBaseUrl;
    protected String proxyUrlPrefixToRemove;
    protected Fault fault;
    protected List<String> responseTransformerNames;
    protected Map<String, Object> transformerParameters = new HashMap<String, Object>();
    protected Boolean wasConfigured = true;

    public static ResponseDefinitionBuilder like(ResponseDefinition responseDefinition) {
        ResponseDefinitionBuilder builder = new ResponseDefinitionBuilder();
        builder.status = responseDefinition.getStatus();
        builder.statusMessage = responseDefinition.getStatusMessage();
        builder.headers = responseDefinition.getHeaders() != null ? new ArrayList<HttpHeader>(responseDefinition.getHeaders().all()) : new ArrayList();
        builder.body = responseDefinition.getReponseBody();
        builder.bodyFileName = responseDefinition.getBodyFileName();
        builder.fixedDelayMilliseconds = responseDefinition.getFixedDelayMilliseconds();
        builder.delayDistribution = responseDefinition.getDelayDistribution();
        builder.chunkedDribbleDelay = responseDefinition.getChunkedDribbleDelay();
        builder.proxyBaseUrl = responseDefinition.getProxyBaseUrl();
        builder.proxyUrlPrefixToRemove = responseDefinition.getProxyUrlPrefixToRemove();
        builder.fault = responseDefinition.getFault();
        builder.responseTransformerNames = responseDefinition.getTransformers();
        builder.transformerParameters = responseDefinition.getTransformerParameters() != null ? Parameters.from(responseDefinition.getTransformerParameters()) : Parameters.empty();
        builder.wasConfigured = responseDefinition.isFromConfiguredStub();
        if (builder.proxyBaseUrl != null) {
            ProxyResponseDefinitionBuilder proxyResponseDefinitionBuilder = new ProxyResponseDefinitionBuilder(builder);
            proxyResponseDefinitionBuilder.proxyUrlPrefixToRemove = responseDefinition.getProxyUrlPrefixToRemove();
            proxyResponseDefinitionBuilder.additionalRequestHeaders = responseDefinition.getAdditionalProxyRequestHeaders() != null ? (List)responseDefinition.getAdditionalProxyRequestHeaders().all() : new ArrayList();
            proxyResponseDefinitionBuilder.removeRequestHeaders = responseDefinition.getRemoveProxyRequestHeaders() != null ? responseDefinition.getRemoveProxyRequestHeaders() : new ArrayList<String>();
            return proxyResponseDefinitionBuilder;
        }
        return builder;
    }

    public static ResponseDefinition jsonResponse(Object body) {
        return ResponseDefinitionBuilder.jsonResponse(body, 200);
    }

    public static ResponseDefinition jsonResponse(Object body, int status) {
        return new ResponseDefinitionBuilder().withBody(Json.write(body)).withStatus(status).withHeader("Content-Type", "application/json").build();
    }

    public ResponseDefinitionBuilder but() {
        return this;
    }

    public ResponseDefinitionBuilder withStatus(int status) {
        this.status = status;
        return this;
    }

    public ResponseDefinitionBuilder withHeader(String key, String ... values2) {
        this.headers.add(new HttpHeader(key, values2));
        return this;
    }

    public ResponseDefinitionBuilder withBodyFile(String fileName) {
        this.bodyFileName = fileName;
        return this;
    }

    public ResponseDefinitionBuilder withBody(String body) {
        this.body = Body.fromOneOf(null, body, null, null);
        return this;
    }

    public ResponseDefinitionBuilder withBody(byte[] body) {
        this.body = Body.fromOneOf(body, null, null, null);
        return this;
    }

    public ResponseDefinitionBuilder withResponseBody(Body body) {
        this.body = body;
        return this;
    }

    public ResponseDefinitionBuilder withJsonBody(JsonNode jsonBody) {
        this.body = Body.fromOneOf(null, null, jsonBody, null);
        return this;
    }

    public ResponseDefinitionBuilder withFixedDelay(Integer milliseconds) {
        this.fixedDelayMilliseconds = milliseconds;
        return this;
    }

    public ResponseDefinitionBuilder withRandomDelay(DelayDistribution distribution) {
        this.delayDistribution = distribution;
        return this;
    }

    public ResponseDefinitionBuilder withLogNormalRandomDelay(double medianMilliseconds, double sigma) {
        return this.withRandomDelay(new LogNormal(medianMilliseconds, sigma));
    }

    public ResponseDefinitionBuilder withUniformRandomDelay(int lowerMilliseconds, int upperMilliseconds) {
        return this.withRandomDelay(new UniformDistribution(lowerMilliseconds, upperMilliseconds));
    }

    public ResponseDefinitionBuilder withChunkedDribbleDelay(int numberOfChunks, int totalDuration) {
        this.chunkedDribbleDelay = new ChunkedDribbleDelay(numberOfChunks, totalDuration);
        return this;
    }

    public ResponseDefinitionBuilder withTransformers(String ... responseTransformerNames) {
        this.responseTransformerNames = Arrays.asList(responseTransformerNames);
        return this;
    }

    public ResponseDefinitionBuilder withTransformerParameters(Map<String, Object> parameters) {
        this.transformerParameters.putAll(parameters);
        return this;
    }

    public ResponseDefinitionBuilder withTransformerParameter(String name, Object value) {
        this.transformerParameters.put(name, value);
        return this;
    }

    public ResponseDefinitionBuilder withTransformer(String transformerName, String parameterKey, Object parameterValue) {
        this.withTransformers(transformerName);
        this.withTransformerParameter(parameterKey, parameterValue);
        return this;
    }

    public ProxyResponseDefinitionBuilder proxiedFrom(String proxyBaseUrl) {
        this.proxyBaseUrl = proxyBaseUrl;
        return new ProxyResponseDefinitionBuilder(this);
    }

    public ResponseDefinitionBuilder withGzipDisabled(boolean gzipDisabled) {
        if (gzipDisabled) {
            this.headers.add(new HttpHeader("Content-Encoding", "none"));
        }
        return this;
    }

    public static ResponseDefinitionBuilder responseDefinition() {
        return new ResponseDefinitionBuilder();
    }

    public static <T> ResponseDefinitionBuilder okForJson(T body) {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody(Json.write(body)).withHeader("Content-Type", "application/json");
    }

    public static <T> ResponseDefinitionBuilder okForEmptyJson() {
        return ResponseDefinitionBuilder.responseDefinition().withStatus(200).withBody("{}").withHeader("Content-Type", "application/json");
    }

    public ResponseDefinitionBuilder withHeaders(HttpHeaders headers) {
        this.headers = new ArrayList<HttpHeader>(headers.all());
        return this;
    }

    public ResponseDefinitionBuilder withBase64Body(String base64Body) {
        this.body = Body.fromOneOf(null, null, null, base64Body);
        return this;
    }

    public ResponseDefinitionBuilder withStatusMessage(String message) {
        this.statusMessage = message;
        return this;
    }

    public ResponseDefinitionBuilder withFault(Fault fault) {
        this.fault = fault;
        return this;
    }

    public ResponseDefinition build() {
        return this.build(null, null, null);
    }

    protected ResponseDefinition build(HttpHeaders additionalProxyRequestHeaders, List<String> removeProxyRequestHeaders, String proxyUrlPrefixToRemove) {
        HttpHeaders httpHeaders = this.headers == null || this.headers.isEmpty() ? null : new HttpHeaders(this.headers);
        Parameters transformerParameters = this.transformerParameters == null || this.transformerParameters.isEmpty() ? null : Parameters.from(this.transformerParameters);
        return new ResponseDefinition(this.status, this.statusMessage, this.body, this.bodyFileName, httpHeaders, additionalProxyRequestHeaders, removeProxyRequestHeaders, this.fixedDelayMilliseconds, this.delayDistribution, this.chunkedDribbleDelay, this.proxyBaseUrl, proxyUrlPrefixToRemove, this.fault, this.responseTransformerNames, transformerParameters, this.wasConfigured);
    }

    public static class ProxyResponseDefinitionBuilder
    extends ResponseDefinitionBuilder {
        private List<HttpHeader> additionalRequestHeaders = new ArrayList<HttpHeader>();
        private List<String> removeRequestHeaders = new ArrayList<String>();

        public ProxyResponseDefinitionBuilder(ResponseDefinitionBuilder from) {
            this.status = from.status;
            this.statusMessage = from.statusMessage;
            this.headers = from.headers;
            this.body = from.body;
            this.bodyFileName = from.bodyFileName;
            this.fault = from.fault;
            this.fixedDelayMilliseconds = from.fixedDelayMilliseconds;
            this.delayDistribution = from.delayDistribution;
            this.chunkedDribbleDelay = from.chunkedDribbleDelay;
            this.proxyBaseUrl = from.proxyBaseUrl;
            this.proxyUrlPrefixToRemove = from.proxyUrlPrefixToRemove;
            this.responseTransformerNames = from.responseTransformerNames;
            this.transformerParameters = from.transformerParameters;
        }

        public ProxyResponseDefinitionBuilder withAdditionalRequestHeader(String key, String value) {
            this.additionalRequestHeaders.add(new HttpHeader(key, value));
            return this;
        }

        public ProxyResponseDefinitionBuilder withRemoveRequestHeader(String key) {
            this.removeRequestHeaders.add(key.toLowerCase());
            return this;
        }

        public ProxyResponseDefinitionBuilder withProxyUrlPrefixToRemove(String proxyUrlPrefixToRemove) {
            this.proxyUrlPrefixToRemove = proxyUrlPrefixToRemove;
            return this;
        }

        @Override
        public ResponseDefinition build() {
            return super.build(!this.additionalRequestHeaders.isEmpty() ? new HttpHeaders(this.additionalRequestHeaders) : null, !this.removeRequestHeaders.isEmpty() ? this.removeRequestHeaders : null, this.proxyUrlPrefixToRemove);
        }
    }
}

